#pragma once

#include "BaseWindow.h"

#include "Rtf2Bmp.h"
#include "MemoryUtility.h"

typedef struct RectD {
    double x,y;
    double dx,dy;
} RectD;

class SizeI {
public:
    SizeI(int _dx, int _dy) { dx = _dx; dy = _dy; }
    void set(int _dx, int _dy) { dx = _dx; dy = _dy; }
    int dx;
    int dy;
};

class SizeD {
public:
    SizeD(double dx, double dy) { m_dx = dx; m_dy = dy; }
    SizeD(int dx, int dy) { m_dx = (double)dx; m_dy = (double)dy; }
    SizeD(SizeI si) { m_dx = (double)si.dx; m_dy = (double)si.dy; }
    SizeD() { m_dx = 0; m_dy = 0; }
    int dxI() { return (int)m_dx; }
    int dyI() { return (int)m_dy; }
    double dx() { return m_dx; }
    double dy() { return m_dy; }
    void setDx(double dx) { m_dx = dx; }
    void setDy(double dy) { m_dy = dy; }
    SizeI size() { return SizeI(dx(), dy()); }
private:
    double m_dx;
    double m_dy;
};
class CNote
{
public:
	CNote(void);

	CString m_strNote;
	RECT	m_rNote;
	HBITMAP m_hBmp;
	double	m_zoom;
	double	m_zoomAtIns;
	bool	m_bIsSelected;

	POINT	CenterPoint();
	double	Width();
	double	Height();
	POINT	TopLeft();
	POINT	BottomRight();
	void	FindNotePoints(POINT *p1, POINT *p2, POINT *p3, POINT *p4);

public:
	~CNote(void);
};

class CWindowcanvas: public bWindow 
{
public:
		// the constructor takes two arguments, the window's title, and the Window Class' name
		// the Window Class must be registered using the SimpleWindowClass object
		// you can retrieve the Window Class name using the SimpleWindowClass::className () method
		CWindowcanvas (const TCHAR *windowName, const TCHAR *className);

		~CWindowcanvas(void);
 
		// this is our window's procedure, you're gonna implement it like any other window procedure
		LRESULT CALLBACK wndProc (HWND, UINT, WPARAM, LPARAM);
 
		// shows the window on the screen and updates its client area
		void Show () { 
			::ShowWindow (_hwnd, SW_SHOW);
			::UpdateWindow (_hwnd);
		}

		void Update(){::UpdateWindow(_hwnd);};

		void SetParent(HWND p){_hwndParent = p;};

		void SetRTF2BMP(IRtf2Bmp *Rtf2Bmp){m_Rtf2Bmp = Rtf2Bmp;};

//Variables
		IRtf2Bmp *m_Rtf2Bmp;

//Variables to get Notes
		//The Notes
		CNote	**m_notes;
		long	m_numNotes;
		int		m_posNoteSel;

		int m_deltaX;
		int m_deltaY;

		CNote*		AddNote(RectD r, CString str, HBITMAP bmp, double zoom);
		void		DeleteNote(int pos);
		void		ModifyNote(CNote *n, CString str, SizeD dimension, HBITMAP bmp);
		CNote*		GetNote(int i);
		long		GetNumNote();

		void		FreeResurces();

		void		RenderAllNotes(double zoom);

};
