#include "StdAfx.h"
#include "Windowcanvas.h"

#include "windowsx.h"

//---------------------------------------CNote------------------------------------
//--------------------------------------------------------------------------------------------
CNote::CNote(void)
{
	m_strNote = _T("");
}

CNote::~CNote(void)
{
}

POINT CNote::CenterPoint()
{
	POINT p;
	p.x = m_rNote.left + (m_rNote.right - m_rNote.left)/2;
	p.y = m_rNote.top + (m_rNote.bottom - m_rNote.top)/2;

	return p;
}

void CNote::FindNotePoints(POINT *p1, POINT *p2, POINT *p3, POINT *p4)
{
	//Find Rectangle Points
	*p1 = TopLeft();
	*p3 = BottomRight();
	*p2 = *p1;
	p2->x = p2->x + Width();
	*p4 = *p3;
	p4->x = p4->x - Width();
}

double CNote::Width()
{
	return (m_rNote.right - m_rNote.left);
}

double CNote::Height()
{
	return (m_rNote.bottom - m_rNote.top);
}


POINT CNote::TopLeft()
{
	POINT p;
	p.x = m_rNote.left;
	p.y = m_rNote.top;

	return p;
}

POINT CNote::BottomRight()
{
	POINT p;
	p.x = m_rNote.right;
	p.y = m_rNote.bottom;

	return p;
}


//-------------------------------CWindowCanvas-----------------------------------
//-------------------------------------------------------------------------------

CWindowcanvas::CWindowcanvas (const TCHAR *windowName, const TCHAR *className)
	:	bWindow ()
{
	_windowName = windowName;
	_className = className;
	_hInstance = ::GetModuleHandle (NULL); // or you could've passed the HINSTANCE as a constructor parameter
	_style = WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN ;
	_y = _x = CW_USEDEFAULT;
	_height = _width = CW_USEDEFAULT;
	_styleEx = 0;
	_hwndParent = 0;
	_hMenu = 0;
	_height = 30;

	//Variables for the notes
	m_numNotes = 0;

	m_notes = NULL;
}

CWindowcanvas::~CWindowcanvas(void)
{
}

void CWindowcanvas::FreeResurces()
{
	int n = m_numNotes;
	for(int i=0;i<n; i++)
	{
		DeleteNote(0);
	}
	m_numNotes = 0;
	free(m_notes);
	m_notes = NULL;
}

// our window procedure, this is were we define our window's behavior
LRESULT CALLBACK CWindowcanvas::wndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_CREATE:
			SetWindowPos(hwnd,NULL, 0,0, 500, 500, SWP_NOACTIVATE | SWP_NOREPOSITION | SWP_NOMOVE| SWP_NOZORDER);
			return 0;
		case WM_DESTROY:
			FreeResurces();

			::PostQuitMessage (0);
			return 0;
		case WM_ERASEBKGND:
			return 1;
		case WM_SIZE:
			{
				break;
			}
		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				HDC hdc = BeginPaint(hwnd, &ps);

				HDC bmpDCTot = CreateCompatibleDC(hdc);
				HBITMAP bmpTot = CreateCompatibleBitmap(hdc, ps.rcPaint.right - ps.rcPaint.left, ps.rcPaint.bottom - ps.rcPaint.top);
				SelectObject(bmpDCTot, bmpTot);

				HBRUSH brushBg = CreateSolidBrush(RGB(255,255,255));
				FillRect(bmpDCTot, &(ps.rcPaint), brushBg);
				DeleteObject(brushBg);

				HDC bmpDC = CreateCompatibleDC(hdc);
				for(int i= 0; i< m_numNotes; i++)
				{
					CNote *n = GetNote(i);

					RECT rNote;
					rNote.left = n->m_rNote.left;
					rNote.top = n->m_rNote.top;
					rNote.right = n->m_rNote.right;
					rNote.bottom = n->m_rNote.bottom;

					SelectObject(bmpDC, n->m_hBmp);
					BitBlt(bmpDCTot, rNote.left, rNote.top, rNote.right - rNote.left, rNote.bottom - rNote.top, bmpDC, 0,0, SRCCOPY);
				}

				BitBlt(hdc, ps.rcPaint.left, ps.rcPaint.top, ps.rcPaint.right - ps.rcPaint.left, ps.rcPaint.bottom - ps.rcPaint.top, bmpDCTot, 0,0, SRCCOPY);

				DeleteDC(bmpDC);
				DeleteDC(bmpDCTot);
				DeleteObject(bmpTot);

				EndPaint(hwnd, &ps);
				return 0;
			}
		case WM_LBUTTONDOWN:
			{
				int x = GET_X_LPARAM(lParam);
				int y = GET_Y_LPARAM(lParam);
	
				//Controllo se ho selezionato una nota
				POINT p; 
				p.x = x; 
				p.y = y;

				BOOL ret = FALSE;
				for(int i=0;i<m_numNotes;i++)
				{
					CNote *n = GetNote(i);
					if(PtInRect(&(n->m_rNote), p) == TRUE)
					{
						ret = TRUE;
						m_posNoteSel = i;
						break;
					}
				}

				return 0;
			}
		case WM_LBUTTONUP:
			{
				m_posNoteSel = -1;
				break;
			}
		case WM_LBUTTONDBLCLK:
			{
				//Intercettato il messaggio del doppio click
				int x = GET_X_LPARAM(lParam);
				int y = GET_Y_LPARAM(lParam);

				CString str;
				long h, w;
				str = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1040{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}}{\\*\\generator Msftedit 5.41.15.1507;}\\viewkind4\\uc1\\pard\\f0\\fs20 pippo\\par e\\par pluto topolino\\par}";
				m_Rtf2Bmp->put_RTFText(str);

				//Setto lo zoom
				m_Rtf2Bmp->setZoom(NULL);

				m_Rtf2Bmp->get_NaturalSize(&h, &w);
				RectD r;
				r.x = x;
				r.y = y;
				r.dx = w;
				r.dy = h;

				//Creo la bitmap...
				PAINTSTRUCT ps;
				HDC hdc = BeginPaint(hwnd, &ps);

				HDC bmpDC = CreateCompatibleDC(hdc);
				HBITMAP bmp = CreateCompatibleBitmap(hdc, w, h);
				SelectObject(bmpDC, bmp);
				HBRUSH hbrBkgnd = CreateSolidBrush(RGB(255,255,255));

				RECT r1;
				r1.left = 0;
				r1.top = 0;
				r1.right = w;
				r1.bottom = h;

				FillRect(bmpDC, &r1, hbrBkgnd);
				DeleteObject(hbrBkgnd);
				m_Rtf2Bmp->Draw(bmpDC, &r1);

//				BitBlt(hdc, r1.left, r1.top, r1.right - r1.left, r1.bottom - r1.top, bmpDC, 0,0, SRCCOPY);

				EndPaint(hwnd, &ps);

				//Aggiungo la nota
				AddNote(r, str,bmp, 0);

				//Ridisegno tutto
				RECT rClient;
				GetClientRect(hwnd, &rClient);
				InvalidateRect(hwnd, &rClient, FALSE); 
			}
			break;
		case WM_MOUSEMOVE:
			{
				int x = GET_X_LPARAM(lParam);
				int y = GET_Y_LPARAM(lParam);

				if(m_posNoteSel>-1)
				{
					CNote *n = GetNote(m_posNoteSel);

					long w = n->m_rNote.right - n->m_rNote.left;
					long h = n->m_rNote.bottom - n->m_rNote.top;

					n->m_rNote.left = x;
					n->m_rNote.top = y;
					n->m_rNote.right = x + w;
					n->m_rNote.bottom = y + h;

					//Ridisegno tutto
					RECT r = n->m_rNote;
					InflateRect(&r, 100, 100);
					InvalidateRect(hwnd, NULL/*&(r)*/, FALSE);
				}

				break;
			}
		default:
			return ::DefWindowProc (hwnd, message, wParam, lParam);
	}
}

CNote* CWindowcanvas::AddNote(RectD r, CString str, HBITMAP bmp, double zoom)
{
	//New note
	CNote *n;

	n = new CNote();
	n->m_strNote = str;
	n->m_rNote.left = r.x;
	n->m_rNote.top = r.y;
	n->m_rNote.right = r.x + r.dx;
	n->m_rNote.bottom = r.y + r.dy;
	n->m_zoom = zoom;
	n->m_zoomAtIns = zoom;

	//La bitmap
	if(bmp != NULL)
	{
		BITMAP BitmapInfo;
		GetObject(bmp, sizeof(BITMAP), &BitmapInfo);
		BitmapInfo.bmBits = new BYTE[BitmapInfo.bmWidthBytes*BitmapInfo.bmHeight];
		GetBitmapBits(bmp,BitmapInfo.bmWidthBytes*BitmapInfo.bmHeight, BitmapInfo.bmBits);

		n->m_hBmp = CreateBitmapIndirect(&BitmapInfo);

		delete[] BitmapInfo.bmBits; 
	}

	m_notes = (CNote **)greallocn(m_notes, m_numNotes+1, sizeof(CNote *));
	m_notes[m_numNotes] = n;
	m_numNotes++;

	return n;
}

void CWindowcanvas::ModifyNote(CNote *n, CString str, SizeD dimension, HBITMAP bmp)
{
	//The string
	n->m_strNote = str;

	//Bounding Rectangle (I modify only width and height and not the position)
	n->m_rNote.right = n->m_rNote.left + dimension.dxI();
	n->m_rNote.bottom = n->m_rNote.top + dimension.dyI();

	//Bitmap
	BITMAP BitmapInfo;
	GetObject(bmp, sizeof(BITMAP), &BitmapInfo);
	BitmapInfo.bmBits = new BYTE[BitmapInfo.bmWidthBytes*BitmapInfo.bmHeight];
	GetBitmapBits(bmp,BitmapInfo.bmWidthBytes*BitmapInfo.bmHeight, BitmapInfo.bmBits);

	n->m_hBmp = CreateBitmapIndirect(&BitmapInfo);

	delete[] BitmapInfo.bmBits; 

}

void CWindowcanvas::DeleteNote(int pos)
{
	CNote *n = m_notes[pos];

	//Repositioning elements
	if(pos<m_numNotes)
	{
		for(int i=pos+1; i<m_numNotes;i++)
		{
			CNote *ncurr = m_notes[i];
			m_notes[i-1] = ncurr;
		}

		//Delete last line
		m_notes[m_numNotes-1] = NULL;
	}

	delete n;
	m_numNotes--;
}

CNote* CWindowcanvas::GetNote(int i)
{
	if(i<0)
		return NULL;
	else
		return m_notes[i];
}

long CWindowcanvas::GetNumNote()
{
	return m_numNotes;
}

void CWindowcanvas::RenderAllNotes(double zoom)
{
	HWND hwnd = GetWnd();

	//Creo la bitmap...
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(hwnd, &ps);

	for(int i=0; i< m_numNotes;i++)
	{
		CNote *n = GetNote(i);

		long h, w;
		m_Rtf2Bmp->put_RTFText(n->m_strNote);

		//Setto lo zoom
		m_Rtf2Bmp->setZoom(zoom);

		m_Rtf2Bmp->get_NaturalSize(&h, &w);

		HDC bmpDC = CreateCompatibleDC(hdc);
		HBITMAP bmp = CreateCompatibleBitmap(hdc, w, h);
		SelectObject(bmpDC, bmp);
		HBRUSH hbrBkgnd = CreateSolidBrush(RGB(255,255,255));

		RECT r1;
		r1.left = 0;
		r1.top = 0;
		r1.right = w;
		r1.bottom = h;

		FillRect(bmpDC, &r1, hbrBkgnd);
		DeleteObject(hbrBkgnd);
		m_Rtf2Bmp->Draw(bmpDC, &r1);

		SizeD dim((double)w, (double) h);
		ModifyNote(n,n->m_strNote, dim, bmp);

		DeleteDC(bmpDC);
		DeleteObject(bmp);
	}

	EndPaint(hwnd, &ps);

	RECT rClient;
	GetClientRect(hwnd, &rClient);
	InvalidateRect(hwnd, &rClient, FALSE); 
}