#include "StdAfx.h"
#include  <windows.h>
#include "Rtf2Bmp.h"

static DWORD __stdcall MEditStreamInCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb)
{
	CString *psBuffer = (CString *)dwCookie;

	if (cb > psBuffer->GetLength()) cb = psBuffer->GetLength();

	for (int i=0;i<cb;i++) {
		*(pbBuff+i) = psBuffer->GetAt(i);
	}

	*pcb = cb;

	*psBuffer = psBuffer->Mid(cb);

	return 0;
}
CRtf2Bmp::CRtf2Bmp(void)
{
	HDC hdcScreen;

	hdcScreen = GetDC(NULL);
	nPixelsPerInchX = GetDeviceCaps(hdcScreen, LOGPIXELSX);
	nPixelsPerInchY = GetDeviceCaps(hdcScreen, LOGPIXELSY);
	ReleaseDC(NULL, hdcScreen);

	SetRectEmpty(&m_rcClient);
	SetRectEmpty(&m_rcViewInset);

	m_pCF = (CHARFORMAT2W*) malloc(sizeof(CHARFORMAT2W));

	InitDefaultCharFormat();
	InitDefaultParaFormat();
	m_spTextServices = NULL;

//	m_dwPropertyBits = TXTBIT_RICHTEXT | TXTBIT_MULTILINE | TXTBIT_WORDWRAP | TXTBIT_USECURRENTBKG;
	m_dwPropertyBits = TXTBIT_RICHTEXT | TXTBIT_MULTILINE | TXTBIT_USECURRENTBKG;
	m_dwScrollbar = 0;
	m_dwMaxLength = INFINITE;
}

CRtf2Bmp::~CRtf2Bmp(void)
{
}


/////////////////////////////////////////////////////////////////////////////
// CFormattedTextDraw

HRESULT CRtf2Bmp::get_RTFText(/*BSTR *pVal*/ CString *str)
{
	str = &m_rtf;
	return S_OK;
}

HRESULT CRtf2Bmp::put_RTFText(/*BSTR newVal*/ CString str)
{

//	m_rtf = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1040{\\fonttbl{\\f0\\fnil\\fcharset0 Arial;}}\\viewkind4\\uc1\\pard\\f0\\fs17 Nota\\par}";
//	m_rtf = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1040{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}}{\\*\\generator Msftedit 5.41.15.1507;}\\viewkind4\\uc1\\pard\\f0\\fs20 pippo\\par e\\par pluto topolino\\par}";
//	m_rtf = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1040{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}}{\\colortbl ;\\red255\\green0\\blue0;}{\\*\\generator Msftedit 5.41.15.1507;}\\viewkind4\\uc1\\pard\\cf1\\f0\\fs20 pippo\\par pluto e topolino\\cf0\\par}";

	m_rtf = str;

	HRESULT hr;
	LRESULT lResult = 0;
	EDITSTREAM es;
	es.dwCookie = (DWORD)&m_rtf;			// Pass a pointer to the CString to the callback function
	es.pfnCallback = MEditStreamInCallback;
	hr = m_spTextServices->TxSendMessage(EM_STREAMIN, (WPARAM)(SF_RTF | SF_UNICODE), (LPARAM)&es, &lResult);

	return S_OK;
}

void CRtf2Bmp::setZoom(double zoom)
{
	if(zoom!=NULL)
		m_zoom = zoom;

	if(m_zoom == 0.0)
		m_zoom = 1.0;

	zoom = m_zoom *1000;

	//Set zoom
	LRESULT lResult = 0;
	HRESULT hr = m_spTextServices->TxSendMessage(EM_SETZOOM, zoom, 1000, &lResult);	
}

HRESULT CRtf2Bmp::Draw(void *hdcDraw, RECT *prc)
{
	HRESULT hr;

	LRESULT lResult;
	hr = m_spTextServices->TxDraw(
	    DVASPECT_CONTENT,  		// Draw Aspect
		0,						// Lindex
		NULL,					// Info for drawing optimization
		NULL,					// target device information
		(HDC) hdcDraw,				// Draw device HDC
		NULL,			 	   	// Target device HDC
		(RECTL *) prc,			// Bounding client rectangle
		NULL,					// Clipping rectangle for metafiles
		(RECT *) NULL,			// Update rectangle
		NULL, 	   				// Call back function
		NULL,					// Call back parameter
		TXTVIEW_INACTIVE);		// What view of the object could be TXTVIEW_ACTIVE

	return hr;
}

HRESULT CRtf2Bmp::Create()
{
	m_zoom = 1.0;

	return CreateTextServicesObject();
}

HRESULT CRtf2Bmp::get_NaturalWidth(long Height, long *pVal)
{
	long lWidth;
	SIZEL szExtent;
	HDC	hdcDraw;

	if (!m_spTextServices)
		return S_FALSE;

	hdcDraw = GetDC(NULL);
	szExtent.cy = Height;
	szExtent.cx = 10000;
	lWidth = 10000;
	m_spTextServices->TxGetNaturalSize(DVASPECT_CONTENT, 
		hdcDraw, 
		NULL,
		NULL,
		TXTNS_FITTOCONTENT,
		&szExtent,
		&lWidth,
		&Height);

	ReleaseDC(NULL, hdcDraw);
	*pVal = lWidth;

	return S_OK;
}

HRESULT CRtf2Bmp::get_NaturalHeight(long Width, long *pVal)
{

	long lHeight;
	SIZEL szExtent;
	HDC	hdcDraw;

	if (!m_spTextServices)
		return S_FALSE;

	hdcDraw = GetDC(NULL);
	szExtent.cx = Width;
	szExtent.cy = 10000;
	lHeight = 10000;
	m_spTextServices->TxGetNaturalSize(DVASPECT_CONTENT, 
		hdcDraw, 
		NULL,
		NULL,
		TXTNS_FITTOCONTENT,
		&szExtent,
		&Width,
		&lHeight);

	ReleaseDC(NULL, hdcDraw);
	*pVal = lHeight;

	return S_OK;
}

HRESULT CRtf2Bmp::get_NaturalSize(long *Height, long *Width)
{
	long lWidth = 0;
	long lHeight = 0;
	SIZEL szExtent;
	HDC	hdcDraw;

	if (!m_spTextServices)
		return S_FALSE;

	hdcDraw = GetDC(NULL);
	szExtent.cy = 1;
	szExtent.cx = 10000;
	lWidth = 10000;
	m_spTextServices->TxGetNaturalSize(DVASPECT_CONTENT, 
		hdcDraw, 
		NULL,
		NULL,
		TXTNS_FITTOCONTENT,
		&szExtent,
		&lWidth,
		&lHeight);

	ReleaseDC(NULL, hdcDraw);
	*Width = lWidth;
	*Height = lHeight;

	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// ITextHost functions
HDC CRtf2Bmp::TxGetDC()
{
	if(m_wndParent==NULL)
		return NULL;

	HDC hdc = GetDC(m_wndParent);
	int mmode1 = GetMapMode(hdc);
	return hdc;
}

INT CRtf2Bmp::TxReleaseDC(HDC hdc)
{
	if(m_wndParent)
		ReleaseDC(m_wndParent, hdc);

	return 1;
}

BOOL CRtf2Bmp::TxShowScrollBar(INT fnBar, BOOL fShow)
{
	return FALSE;
}

BOOL CRtf2Bmp::TxEnableScrollBar(INT fuSBFlags, INT fuArrowflags)
{
	return FALSE;
}

BOOL CRtf2Bmp::TxSetScrollRange(INT fnBar, LONG nMinPos, INT nMaxPos, BOOL fRedraw)
{
	return FALSE;
}

BOOL CRtf2Bmp::TxSetScrollPos(INT fnBar, INT nPos, BOOL fRedraw)
{
	return FALSE;
}

void CRtf2Bmp::TxInvalidateRect(LPCRECT prc, BOOL fMode)
{
}

void CRtf2Bmp::TxViewChange(BOOL fUpdate)
{
}

BOOL CRtf2Bmp::TxCreateCaret(HBITMAP hbmp, INT xWidth, INT yHeight)
{
	return FALSE;
}

BOOL CRtf2Bmp::TxShowCaret(BOOL fShow)
{
	return FALSE;
}

BOOL CRtf2Bmp::TxSetCaretPos(INT x, INT y)
{
	return FALSE;
}

BOOL CRtf2Bmp::TxSetTimer(UINT idTimer, UINT uTimeout)
{
	return FALSE;
}

void CRtf2Bmp::TxKillTimer(UINT idTimer)
{
}

void CRtf2Bmp::TxScrollWindowEx(INT dx, INT dy, LPCRECT lprcScroll, LPCRECT lprcClip, HRGN hrgnUpdate, LPRECT lprcUpdate, UINT fuScroll)
{
}

void CRtf2Bmp::TxSetCapture(BOOL fCapture)
{
}

void CRtf2Bmp::TxSetFocus()
{
}

void CRtf2Bmp::TxSetCursor(HCURSOR hcur, BOOL fText)
{
}

BOOL CRtf2Bmp::TxScreenToClient(LPPOINT lppt)
{
	return FALSE;
}

BOOL CRtf2Bmp::TxClientToScreen(LPPOINT lppt)
{
	return FALSE;
}

HRESULT	CRtf2Bmp::TxActivate(LONG * plOldState)
{
	return S_OK;
}

HRESULT	CRtf2Bmp::TxDeactivate(LONG lNewState)
{
	return S_OK;
}

HRESULT	CRtf2Bmp::TxGetClientRect(LPRECT prc)
{
	*prc = m_rcClient;
	return S_OK;
}

HRESULT	CRtf2Bmp::TxGetViewInset(LPRECT prc)
{
	*prc = m_rcViewInset;
	return S_OK;
}

HRESULT CRtf2Bmp::TxGetCharFormat(const CHARFORMATW **ppCF)
{
	*ppCF = m_pCF;
	return S_OK;
}

HRESULT	CRtf2Bmp::TxGetParaFormat(const PARAFORMAT **ppPF)
{
	*ppPF = &m_PF;
	return S_OK;
}

COLORREF CRtf2Bmp::TxGetSysColor(int nIndex)
{
	return GetSysColor(nIndex);
}

HRESULT	CRtf2Bmp::TxGetBackStyle(TXTBACKSTYLE *pstyle)
{
	*pstyle = TXTBACK_TRANSPARENT;
	return S_OK;
}

HRESULT	CRtf2Bmp::TxGetMaxLength(DWORD *plength)
{
	*plength = m_dwMaxLength;
	return S_OK;
}

HRESULT	CRtf2Bmp::TxGetScrollBars(DWORD *pdwScrollBar)
{
	*pdwScrollBar = m_dwScrollbar;
	return S_OK;
}

HRESULT	CRtf2Bmp::TxGetPasswordChar(TCHAR *pch)
{
	return S_FALSE;
}

HRESULT	CRtf2Bmp::TxGetAcceleratorPos(LONG *pcp)
{
	*pcp = -1;
	return S_OK;
}

HRESULT	CRtf2Bmp::TxGetExtent(LPSIZEL lpExtent)
{
	return E_NOTIMPL;
}

HRESULT CRtf2Bmp::OnTxCharFormatChange(const CHARFORMATW * pcf)
{
	memcpy(m_pCF, pcf, pcf->cbSize);
	return S_OK;
}

HRESULT	CRtf2Bmp::OnTxParaFormatChange(const PARAFORMAT * ppf)
{
	memcpy(&m_PF, ppf, ppf->cbSize);
	return S_OK;
}

HRESULT	CRtf2Bmp::TxGetPropertyBits(DWORD dwMask, DWORD *pdwBits)
{
	*pdwBits = m_dwPropertyBits;
	return S_OK;
}

HRESULT	CRtf2Bmp::TxNotify(DWORD iNotify, void *pv)
{
	return S_OK;
}

HIMC CRtf2Bmp::TxImmGetContext()
{
	return NULL;
}

void CRtf2Bmp::TxImmReleaseContext(HIMC himc)
{
}

HRESULT	CRtf2Bmp::TxGetSelectionBarWidth(LONG *lSelBarWidth)
{
	*lSelBarWidth = 100;
	return S_OK;
}



HRESULT CRtf2Bmp::CharFormatFromHFONT(CHARFORMAT2W* pCF, HFONT hFont)
// Takes an HFONT and fills in a CHARFORMAT2W structure with the corresponding info
{

	HWND hWnd;
	LOGFONT lf;
	HDC hDC;
	LONG yPixPerInch;

	// Get LOGFONT for default font
	if (!hFont)
		hFont = (HFONT) GetStockObject(SYSTEM_FONT);

	// Get LOGFONT for passed hfont
	if (!GetObject(hFont, sizeof(LOGFONT), &lf))
		return E_FAIL;

	// Set CHARFORMAT structure
	memset(pCF, 0, sizeof(CHARFORMAT2W));
	pCF->cbSize = sizeof(CHARFORMAT2W);

	hWnd = GetDesktopWindow();
	hDC = GetDC(hWnd);
	yPixPerInch = GetDeviceCaps(hDC, LOGPIXELSY);
	pCF->yHeight = -lf.lfHeight * LY_PER_INCH / yPixPerInch;
	ReleaseDC(hWnd, hDC);

	pCF->yOffset = 0;
	pCF->crTextColor = 0;

	pCF->dwEffects = CFM_EFFECTS | CFE_AUTOBACKCOLOR;
	pCF->dwEffects &= ~(CFE_PROTECTED | CFE_LINK | CFE_AUTOCOLOR);

	if(lf.lfWeight < FW_BOLD)
		pCF->dwEffects &= ~CFE_BOLD;

	if(!lf.lfItalic)
		pCF->dwEffects &= ~CFE_ITALIC;

	if(!lf.lfUnderline)
		pCF->dwEffects &= ~CFE_UNDERLINE;

	if(!lf.lfStrikeOut)
		pCF->dwEffects &= ~CFE_STRIKEOUT;

	pCF->dwMask = CFM_ALL | CFM_BACKCOLOR | CFM_STYLE;
	pCF->bCharSet = lf.lfCharSet;
	pCF->bPitchAndFamily = lf.lfPitchAndFamily;

#ifdef UNICODE
	_tcscpy(pCF->szFaceName, lf.lfFaceName);
#else
	MultiByteToWideChar(CP_ACP, 0, lf.lfFaceName, LF_FACESIZE, pCF->szFaceName, LF_FACESIZE);
#endif

	return S_OK;
}

HRESULT CRtf2Bmp::InitDefaultCharFormat()
{
	return CharFormatFromHFONT(m_pCF, NULL);
}

HRESULT CRtf2Bmp::InitDefaultParaFormat()
{
	memset(&m_PF, 0, sizeof(PARAFORMAT2));
	m_PF.cbSize = sizeof(PARAFORMAT2);
	m_PF.dwMask = PFM_ALL;
	m_PF.wAlignment = PFA_LEFT;
	m_PF.cTabCount = 1;
	m_PF.rgxTabs[0] = lDefaultTab;
	return S_OK;
}

HRESULT CRtf2Bmp::CreateTextServicesObject()
{
	HRESULT hr;
	IUnknown *spUnk;

	hr = CreateTextServices(NULL, static_cast<ITextHost*>(this), &spUnk);
	if (hr == S_OK) {
		hr = spUnk->QueryInterface(IID_ITextServices, (void**)&m_spTextServices);
		spUnk->Release();
	}
	return hr;
}

void CRtf2Bmp::setParent(HWND hParent)
{
	m_wndParent = hParent;
}