#include "StdAfx.h"
#include "MemoryUtility.h"

#include <assert.h>
#include <stdio.h>

static int OverLimit(size_t size) 
{
	return 0;
}

void gfree(void *p) 
{
  free(p);
}

void *gmalloc(size_t size) 
{
	void *p = NULL;
	if (!OverLimit(size)) 
	{
		if (size <= 0)
			return NULL;
		p = malloc(size);
	}
	return p;
}

void *grealloc(void *p, size_t size) 
{
	void *q = NULL;
	if (!OverLimit(size)) 
	{
		if (size <= 0) 
		{
			if (p)
				free(p);
			return NULL;
		}

		if (p)
			q = realloc(p, size);
		else
			q = malloc(size);
	}
	return q;
}

void *gmallocn(int nObjs, int objSize) 
{
	int n;

	n = nObjs * objSize;
	assert((objSize != 0) && (n / objSize == nObjs));
	if (objSize == 0 || n / objSize != nObjs) 
	{
		fprintf(stderr, "Bogus memory allocation size\n");
		exit(1);
	}
	return gmalloc(n);
}

void *greallocn(void *p, int nObjs, int objSize) 
{
	int n;

	n = nObjs * objSize;
	assert((objSize != 0) && (n / objSize == nObjs));
	if (objSize == 0 || n / objSize != nObjs) 
	{
		fprintf(stderr, "Bogus memory allocation size\n");
		exit(1);
	}
	return grealloc(p, n);
}
