// ConvertRTFtoBMP2.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "ConvertRTFtoBMP2.h"

#include "Rtf2Bmp.h"

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name

HWND			gFrameWnd;
long			g_IDZoomChecked;
CWindowcanvas	*wndCanvas;

IRtf2Bmp		*g_Rtf2Bmp;

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_CONVERTRTFTOBMP2, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_CONVERTRTFTOBMP2));

	RECT rectFrame;
	GetClientRect(gFrameWnd, &rectFrame);

	//SetZoom
	g_IDZoomChecked = ID_ZOOM_100;

	g_Rtf2Bmp = new CRtf2Bmp();
	g_Rtf2Bmp->Create();
	g_Rtf2Bmp->setZoom(1.0);

	bWindowClass winCanvasClass(hInstance, TEXT("WINDOWCANVAS"));
	winCanvasClass.Register();

	wndCanvas = new CWindowcanvas(TEXT ("Canvas Window"), winCanvasClass.className ());
	wndCanvas->SetParent(gFrameWnd);
	wndCanvas->Create();
	wndCanvas->SetRTF2BMP(g_Rtf2Bmp);
 
	// position of the windows
	RECT rect;
	GetClientRect(wndCanvas->GetWnd(), &rect);
	SetWindowPos(wndCanvas->GetWnd(), NULL, 0,0, rectFrame.right - rectFrame.left, rectFrame.bottom - rectFrame.top, NULL);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage are only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= 0;//CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_CONVERTRTFTOBMP2));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_CONVERTRTFTOBMP2);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   gFrameWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN ,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!gFrameWnd)
   {
      return FALSE;
   }

   ShowWindow(gFrameWnd, nCmdShow);
   UpdateWindow(gFrameWnd);

   return TRUE;
}

static double FindZoomFromMenu(long IDMenu)
{
	double retVal;

	switch(IDMenu)
	{
		case ID_ZOOM_50:
			retVal = 0.5;
			break;
		case ID_ZOOM_80:
			retVal = 0.8;
			break;
		case ID_ZOOM_100:
			retVal = 1.0;
			break;
		case ID_ZOOM_120:
			retVal = 1.2;
			break;
		case ID_ZOOM_140:
			retVal = 1.4;
			break;
		case ID_ZOOM_150:
			retVal = 1.5;
			break;
		case ID_ZOOM_170:
			retVal = 1.7;
			break;
		case ID_ZOOM_200:
			retVal = 2.0;
			break;
		case ID_ZOOM_250:
			retVal = 2.5;
			break;
		case ID_ZOOM_300:
			retVal = 3.0;
			break;
		default:
			retVal = 1.0;
	}

	return retVal;
}

//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Parse the menu selections:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		case ID_ZOOM_50:
		case ID_ZOOM_80:
		case ID_ZOOM_100:
		case ID_ZOOM_120:
		case ID_ZOOM_140:
		case ID_ZOOM_150:
		case ID_ZOOM_170:
		case ID_ZOOM_200:
		case ID_ZOOM_250:
		case ID_ZOOM_300:
		{
			HMENU mn = GetMenu(hWnd);

			//Uncheck
			CheckMenuItem(mn, g_IDZoomChecked, MF_BYCOMMAND | MF_UNCHECKED);

			//Check
			CheckMenuItem(mn, wmId, MF_BYCOMMAND | MF_CHECKED);
			g_IDZoomChecked = wmId;

			//Set zoom
			g_Rtf2Bmp->setZoom(FindZoomFromMenu(wmId));
			break;
		}
		case ID_ZOOM_APPLYCURRENTZOOMTOALL:
		{
			wndCanvas->RenderAllNotes(FindZoomFromMenu(g_IDZoomChecked));
		}
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		// TODO: Add any drawing code here...
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	case WM_SIZE:
	{
        int dx = LOWORD(lParam);
        int dy = HIWORD(lParam);
		
		if(wndCanvas)
			SetWindowPos(wndCanvas->GetWnd(), NULL, 0,0, dx, dy, NULL);
		break;
	}
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
