#pragma once

class bWindow {
	protected:
		// window handle
		HWND _hwnd;
 
		// ... other members ...
		DWORD		_styleEx;
		LPCSTR		_className;
		LPCSTR		_windowName;
		DWORD		_style;
		int			_x;
		int			_y;
		int			_width;
		int			_height;
		HWND		_hwndParent;
		HMENU		_hMenu;
		HINSTANCE	_hInstance;

	public:
		bWindow () {}
 
		// this will be WNDCLASSEX::lpfnWndProc
		static LRESULT CALLBACK msgRouter (HWND, UINT, WPARAM, LPARAM);
 
		// this is the actual window procedure
		// this will be implemented in derived classes and will be called by msgRouter
		virtual LRESULT CALLBACK wndProc (HWND, UINT, WPARAM, LPARAM) = 0;
 
		// calls CreateWindowEx, creating the window
		virtual bool Create ();
		virtual void LoadControls(){};
 
		// ... other member functions ...
		HWND GetWnd(){return _hwnd;};
		int GetHeight(){return _height;};
		int GetWidth(){return _width;};
		int GetXPos(){return _x;};
		int GetYPos(){return _y;};
};

class bWindowClass : protected WNDCLASSEX {
	public:
		bWindowClass (HINSTANCE hInst, const TCHAR * className);
 
		// registers the class
		virtual bool Register ();
 
		//retrieve the class name
		virtual const TCHAR * className () const { return lpszClassName; }
 
	protected:
		// --- all WNDCLASSEX's members are protected, so they can be inherited by derived classes ---
};