#include "PdfNotes.h"
#include "..\poppler\goo\gmem.h"
#include "..\BaseUtils\str_util.h"
#include "..\BaseUtils\file_util.h"

#include "NoteDlg.h"

#include "Richedit.h"

static HWND gHwndEditNote;
static HWND hwndCanvas;

//Variabili per gestire le note
static SizeD m_dimMsg;
static HBITMAP hbmp;
static CString strNote;
static bool bUseDlgForOpenPns;
static bool bUseDlgForZoom;
static double actualZoom;


//---------------------------------------Geometry---------------------------------------
//--------------------------------------------------------------------------------------
static double GetAngoloFromPoints(PointD FirstPoint, PointD SecondPoint)
{
	double Angolo = 0.0;

	// Decido in quale quadrante mi trovo...
	if ((SecondPoint.x) > (FirstPoint.x))
	{
		// Sono o nel PRIMO o nel QUARTO quadrante...
		if ((SecondPoint.y) > (FirstPoint.y))
		{
			// Sono nel PRIMO quadrante...
			Angolo = atan((fabs((double)SecondPoint.y-(double)FirstPoint.y))/(fabs((double)SecondPoint.x-(double)FirstPoint.x)));
		}
		else if ((SecondPoint.y) < (FirstPoint.y))
		{
			// Sono nel QUARTO quadrante...
			Angolo = 2.0*_PI_GRECO - atan((fabs((double)SecondPoint.y-(double)FirstPoint.y))/(fabs((double)SecondPoint.x-(double)FirstPoint.x)));
		}
		else
		{
			// Sono sull'asse X che passa per il punto FirstPoint,
			// L'angolo vale 0...
			Angolo = 0.0;
		}
	}
	else if ((SecondPoint.x) < (FirstPoint.x))
	{
		// Sono o nel SECONDO o nel TERZO quadrante...
		if ((SecondPoint.y) > (FirstPoint.y))
		{
			// Sono nel SECONDO quadrante...
			Angolo = _PI_GRECO - atan((fabs((double)SecondPoint.y-(double)FirstPoint.y))/(fabs((double)SecondPoint.x-(double)FirstPoint.x)));
		}
		else if ((SecondPoint.y) < (FirstPoint.y))
		{
			// Sono nel TERZO quadrante...
			Angolo = _PI_GRECO + atan((fabs((double)SecondPoint.y-(double)FirstPoint.y))/(fabs((double)SecondPoint.x-(double)FirstPoint.x)));
		}
		else
		{
			// Sono sull'asse X che passa per il punto FirstPoint,
			// L'angolo vale _Pi...
			Angolo = _PI_GRECO;
		}
	}
	else
	{
		// Sono sull'asse Y che passa per il punto FirstPoint, l'angolo
		// vale _Pi/2 o 3_Pi/2 a seconda del valore della coordinata Y...
		if ((SecondPoint.y) > (FirstPoint.y))
		{
			// L'angolo vale _Pi/2
			Angolo = _PI_GRECO/2.0;
		}
		else if ((SecondPoint.y) < (FirstPoint.y))
		{
			// L'angolo vale 3Pi/2...
			Angolo = 3.0*_PI_GRECO/2.0;
		}
		else
		{
			// Sono sul punto FirstPoint, Assegno all'angolo il valore 0...
			Angolo = 0.0;
		}
	}
	return Angolo;
}

static double Multiplo45(double Angolo)
{
	// Calcolo l'angolo con uno snap di 45 gradi...
	double Ang = _PI_GRECO/4.0, MultiploAngolo = 0.0;
	for (int i=1; i<=8; i++)
	{
		if (Angolo < (MultiploAngolo+Ang/2.0))
			return MultiploAngolo;
		MultiploAngolo += Ang;
	}
	return 0.0;
}

static BOOL IsPointNearLine(PointD p1Line, PointD p2Line, PointD p)
{
	BOOL ret = FALSE;

	double distMin = 10;

	double IntX = 0.0f;
	double IntY = 0.0f;
	double DistP = 0.0f;
	if(p1Line.x != p2Line.x && p1Line.y != p2Line.y)
	{
		//Determino i coefficienti della retta passante fra i due punti
		double A1 = p2Line.y - p1Line.y;
		double B1 = p1Line.x - p2Line.x;
		double C1 = p2Line.x * p1Line.y - p1Line.x * p2Line.y;

		//Determino i coefficienti della retta passante per p e perpindicolare
		//alla retta passante per p1Line e p2Line
		double A2 = B1;
		double B2 = - A1;
		double C2 = A1 * p.y - B1 * p.x;

		//Determino il Punto di intersezione fra le due rette
		IntX = (B1/A1)*(A1*C2 - A2*C1)/(A1*B2 - A2*B1) -(C1/A1);

		IntY = (A2*C1 - A1*C2)/(A1*B2 - A2*B1);

		//Determino la distanza fra il punto p e la linea passante per 
		//p1Line e p2Line
		DistP = fabs(A1*p.x + B1*p.y + C1)/sqrt(pow(A1,2) + pow(B1,2));	
	}
	else if(p1Line.x == p2Line.x )
	{
		//Determino i coefficienti della retta passante fra i due punti
		double A1 = p2Line.y - p1Line.y;
		double C1 = p1Line.x * (p1Line.y - p2Line.y);

		//Determino i coefficienti della retta passante per p e perpindicolare
		//alla retta passante per p1Line e p2Line
		double B2 = - A1;
		double C2 = A1 * p.y;

		//Determino il Punto di intersezione fra le due rette
		IntX = - (C1/A1);

		IntY = - (C2/B2);

		//Determino la distanza fra il punto p e la linea passante per 
		//p1Line e p2Line
		DistP = fabs(A1*p.x + C1)/sqrt(pow(A1,2));
	}
	else if(p1Line.y == p2Line.y )
	{
		//Determino i coefficienti della retta passante fra i due punti
		double B1 = p1Line.x - p2Line.x;
		double C1 = p1Line.y * (p2Line.x - p1Line.x);

		//Determino i coefficienti della retta passante per p e perpindicolare
		//alla retta passante per p1Line e p2Line
		double A2 = B1;
		double C2 = - B1 * p.x;

		//Determino il Punto di intersezione fra le due rette
		IntX = - (C2/A2);

		IntY = - (C1/B1);

		//Determino la distanza fra il punto p e la linea passante per 
		//p1Line e p2Line
		DistP = fabs(B1*p.y + C1)/sqrt(pow(B1,2));
	}

	if(IntX >= min(p1Line.x, p2Line.x) && IntX <= max(p1Line.x, p2Line.x) &&
		IntY >= min(p1Line.y, p2Line.y) && IntY <= max(p1Line.y, p2Line.y) &&
		DistP<distMin)
	{
		ret = TRUE;
	}

	return ret;
}

static PointD CalcolaPointRispettoPoint(PointD pOrigin, double Distanza, double Angolo)
{
	PointD p;

	if(Angolo>=0 && Angolo<=_PI_GRECO/2)
	{
		p.x = pOrigin.x + (int)(Distanza * cos(Angolo));
		p.y = pOrigin.y - (int)(Distanza * sin(Angolo));
	}
	else if (Angolo>_PI_GRECO/2 && Angolo<=_PI_GRECO)
	{
		p.x = pOrigin.x + (int)(Distanza * cos(Angolo));
		p.y = pOrigin.y - (int)(Distanza * sin(_PI_GRECO - Angolo));
	}
	else if(Angolo>_PI_GRECO && Angolo<= (3*_PI_GRECO)/2)
	{
		p.x = pOrigin.x - (int)(Distanza * cos(Angolo -_PI_GRECO));
		p.y = pOrigin.y + (int)(Distanza * sin(Angolo - _PI_GRECO));
	}
	else if(Angolo>=3*_PI_GRECO/2 && Angolo<= 2*_PI_GRECO)
	{
		p.x = pOrigin.x + (int)(Distanza * cos(2*_PI_GRECO - Angolo));
		p.y = pOrigin.y + (int)(Distanza * sin(2*_PI_GRECO - Angolo));
	}

	return p;
}

static BOOL ISSamePoint(PointD p, PointD pConfronto)
{
	BOOL ret = FALSE;

	if(fabsl(p.x-pConfronto.x)<1e-4 && fabsl(p.y-pConfronto.y)<1e-4)
		ret = TRUE;

	return ret;
}

static BOOL IsPointBetweenPoints(PointD p, PointD p1, PointD p2)
{
	BOOL ret = FALSE;

	//Calcolo l'angolo fra i due punti p1 e p2
	double angP1P2 = GetAngoloFromPoints(p1,p2);

	//Calcolo l'angolo fra il punto base p1 e il punto da valutare p
	double angP1P = GetAngoloFromPoints(p1,p);

	if(fabs(angP1P2-angP1P)<1e-1)
	{
		//Sono sulla stessa direzione -> ora valuto la distanza...
		double distP1P2 = sqrt(powl((p1.x-p2.x),2) + powl((p1.y-p2.y),2));

		double distP1P = sqrt(powl((p1.x-p.x),2) + powl((p1.y-p.y),2));
		if(distP1P<=distP1P2)
			ret = TRUE;
	}
	else if(ISSamePoint(p, p1) == TRUE || ISSamePoint(p,p2) == TRUE)
		ret = TRUE;	//Controllo che il punto non coincida con uno dei due

	return ret;
}

//-------------------------------------------UTILITY----------------------------------------
//------------------------------------------------------------------------------------------
static POINT ConvertPointToWin(WindowInfo *win, POINT p)
{
	SCROLLINFO   si = {0};
	int          iVertPos;
	int          iHoriPos;

	si.cbSize = sizeof (si);
	si.fMask  = SIF_ALL;
	GetScrollInfo(win->hwndCanvas, SB_VERT, &si);
	iVertPos = si.nPos;

	GetScrollInfo(win->hwndCanvas, SB_HORZ, &si);
	iHoriPos = si.nPos;

	p.x = p.x - iHoriPos;
	p.y = p.y - iVertPos;

	return p;
}

static bool ConvertPointToWinEX(CPageLinkedPoint p, POINT *pWin, WindowInfo *win)
{
	bool pVisible = false;

	pVisible = p.m_pdfPage->visible;
	bool pShown = p.m_pdfPage->shown;

	if(pVisible == true)
	{
		long xPos;
		if(p.m_pdfPage->bitmapX>0)
			xPos = - p.m_pdfPage->bitmapX;
		else
			xPos = p.m_pdfPage->screenX;

		long yPos;
		if(p.m_pdfPage->bitmapY>0)
			yPos = - p.m_pdfPage->bitmapY;
		else
			yPos = p.m_pdfPage->screenY;

		pWin->y = yPos +  p.m_p.y;
		pWin->x = xPos +  p.m_p.x;
	}
	else
	{
		SCROLLINFO   si = {0};
		int          iVertPos;
		int          iHoriPos;

		si.cbSize = sizeof (si);
		si.fMask  = SIF_ALL;
		GetScrollInfo(win->hwndCanvas, SB_VERT, &si);
		iVertPos = si.nPos;

		GetScrollInfo(win->hwndCanvas, SB_HORZ, &si);
		iHoriPos = si.nPos;

		pWin->y = p.m_pdfPage->currPosY + p.m_p.y - iVertPos;
		pWin->x = p.m_pdfPage->currPosX + p.m_p.x - iHoriPos;
	}

	return pVisible;
}

static RECT ConvertRectToWin(WindowInfo *win, RECT r)
{
	//Devo capire se  visibile...
	SCROLLINFO   si = {0};
	int          iVertPos;
	int			 iHorizPos;

	si.cbSize = sizeof (si);
	si.fMask  = SIF_ALL;
	GetScrollInfo(win->hwndCanvas, SB_VERT, &si);

	iVertPos = si.nPos;

	GetScrollInfo(win->hwndCanvas, SB_HORZ, &si);
	iHorizPos = si.nPos;

	RECT rSup = r;
	rSup.top = rSup.top - iVertPos;
	rSup.bottom = rSup.bottom - iVertPos;
	rSup.left = rSup.left - iHorizPos;
	rSup.right = rSup.right - iHorizPos;

	return rSup;
}

static PointD FindPoint(WindowInfo *win, int x, int y)
{
	SCROLLINFO   si = {0};
	int          iVertPos;
	int          iHoriPos;

	si.cbSize = sizeof (si);
	si.fMask  = SIF_ALL;
	GetScrollInfo(win->hwndCanvas, SB_VERT, &si);
	iVertPos = si.nPos;

	GetScrollInfo(win->hwndCanvas, SB_HORZ, &si);
	iHoriPos = si.nPos;

	int xPos = x + iHoriPos;
	int yPos = y + iVertPos;
	PointD p;
	p.set(xPos, yPos);
	
	return p;
}

static void PaintTransparentRectangle(WindowInfo *win, HDC hdc, RECT *rect, bool bIsSelected, bool bInserting)
{
	if((rect->right -rect->left)<0 || (rect->bottom - rect->top)<0)
		return;

    HBITMAP hbitmap;       // bitmap handle
    BITMAPINFO bmi;        // bitmap header
    VOID *pvBits;          // pointer to DIB section
    BLENDFUNCTION bf;      // structure for alpha blending
    HDC rectDC = CreateCompatibleDC(hdc);
    const DWORD selectionColorYellow = RGB(0,0,255);
    const DWORD selectionColorBlack = 0xff000000;
	const DWORD selectionColorSelected = 0xfff5fc0c;
    const int margin = 1;

    ZeroMemory(&bmi, sizeof(BITMAPINFO));

    bmi.bmiHeader.biSize = sizeof (BITMAPINFOHEADER);
    bmi.bmiHeader.biWidth = rect->right -rect->left;
    bmi.bmiHeader.biHeight = rect->bottom - rect->top;
    bmi.bmiHeader.biPlanes = 1;
    bmi.bmiHeader.biBitCount = 32;
    bmi.bmiHeader.biCompression = BI_RGB;
    bmi.bmiHeader.biSizeImage = (rect->right -rect->left) * (rect->bottom - rect->top) * 4;

    hbitmap = CreateDIBSection (rectDC, &bmi, DIB_RGB_COLORS, &pvBits, NULL, 0x0);
    SelectObject(rectDC, hbitmap);

	if(pvBits==NULL)
		return;

    for (int y = 0; y < (rect->bottom - rect->top); y++) {
        for (int x = 0; x < (rect->right -rect->left); x++) {
            if (x < margin || x > (rect->right -rect->left) - margin - 1 
                    || y < margin || y > (rect->bottom - rect->top) - margin - 1)
			{
				if(bIsSelected == true || bInserting == true)
					((UINT32 *)pvBits)[x + y * (rect->right -rect->left)] = selectionColorBlack;
			}
            else
			{
				if(bIsSelected == true)
					((UINT32 *)pvBits)[x + y * (rect->right -rect->left)] = selectionColorSelected;
				else
					((UINT32 *)pvBits)[x + y * (rect->right -rect->left)] = selectionColorYellow;
			}
        }
    }
    bf.BlendOp = AC_SRC_OVER;
    bf.BlendFlags = 0;
    bf.SourceConstantAlpha = 0x5f;
    bf.AlphaFormat = AC_SRC_ALPHA;

    if (!AlphaBlend(hdc, rect->left, rect->top, (rect->right -rect->left), (rect->bottom - rect->top),
        rectDC, 0, 0, (rect->right -rect->left), (rect->bottom - rect->top), bf))
	{
        //Nothoing TRACE("AlphaBlending error\n");
		int k = 0;
	}
    DeleteObject (hbitmap);
    DeleteDC (rectDC);
}


//------------------------------------------PdfNotes-----------------------------------------
//-------------------------------------------------------------------------------------------
CPdfNotes::CPdfNotes(WindowInfo *win)
{
	m_numNotes = 0;
	m_numConnectors = 0;

	m_curConnectorLine = -1;
	m_curConnector = -1;

	m_curHeightPt = _HEIGHT_10PT;

	m_bUsePdfNotes = false;

	m_notes = NULL;
	m_connectors = NULL;

	m_win = win;

	//Create WindowLess RicheEdit
	m_Rtf2Bmp = new CRtf2Bmp();
	m_Rtf2Bmp->Create();

	//Create Logical font for Notes and for ViewingNotes
	InitializeNoteFont();
	m_fontColor = RGB(0,0,0);

	m_ConnectorColor = _LINE_COLOR_;
	m_ULineColor = _ULINE_COLOR_;
}

void CPdfNotes::InitializeNoteFont()
{
	HDC hDC = GetDC(m_win->hwndCanvas);

	//Minimum Initialize LOGFONT structure
	::ZeroMemory(& m_lfNote, sizeof(LOGFONT));
	_tcscpy(m_lfNote.lfFaceName, _T("Arial"));
	m_lfNote.lfHeight = -MulDiv(10, GetDeviceCaps(hDC, LOGPIXELSY), 72);
	m_lfNote.lfWeight = FW_NORMAL;

	//Log Font for Viewing notes
	::ZeroMemory(& m_lfForViewNote, sizeof(LOGFONT));
	_tcscpy(m_lfForViewNote.lfFaceName, _T("Arial"));
	m_lfForViewNote.lfHeight = -MulDiv(10, GetDeviceCaps(hDC, LOGPIXELSY), 72);
	m_lfForViewNote.lfWeight = FW_NORMAL;

	ReleaseDC(m_win->hwndCanvas, hDC);
}

CPdfNotes::~CPdfNotes(void)
{
}

void CPdfNotes::Load(HINSTANCE h)
{
	if(h==NULL)
		return;

	m_hInst = h;

	m_pnsInAction = false;
	m_pnsCommand = CMD_NO_CMD;
	m_bOrtho = true;
}

void CPdfNotes::OnPaint(HDC hdc/*, WindowInfo *win*/)
{
	if(m_bUsePdfNotes == false)
		return;

	//Draw Connector
	for(int i=0;i<m_numConnectors;i++)
	{
		CConnector *ct = GetConnector(i);
		ct->Draw(m_win, hdc);
	}

    HDC bmpDC = CreateCompatibleDC(hdc);
    if (bmpDC) 
	{
		for(int i=0; i<m_numNotes;i++)
		{
			CNote *n = GetNote(i);
			
			RECT rSup;
			if(IsNoteVisible(m_win, hdc, n, &rSup) == true)
			{
				HPEN penUsed;
				HGDIOBJ prevPen;
				LOGPEN  pen;
				if(n->m_bIsSelected == true)
				{
					pen.lopnStyle = PS_SOLID;
					pen.lopnWidth.x = 1;
					pen.lopnWidth.y = 1;
					pen.lopnColor = _NOTE_SEL_COLOR_;
					penUsed = CreatePenIndirect(&pen);
				}
				else
				{
					pen.lopnStyle = PS_SOLID;
					pen.lopnWidth.x = 1;
					pen.lopnWidth.y = 1;
					pen.lopnColor = _NOTE_COLOR_;
					penUsed = CreatePenIndirect(&pen);
				}

				prevPen = SelectObject(hdc, penUsed);

				Rectangle(hdc, rSup.left -2, rSup.top -1, rSup.right + 1, rSup.bottom +1);

				SelectObject(bmpDC, n->m_hBmp);
				BOOL ret = BitBlt(hdc, rSup.left, rSup.top, rSup.right - rSup.left, rSup.bottom - rSup.top, bmpDC, 0, 0, SRCCOPY);

				SelectObject(hdc, prevPen);
				DeleteObject(penUsed);
			}
		}

        DeleteDC(bmpDC);
    }
}

bool CPdfNotes::IsNoteVisible(WindowInfo *win, HDC hdc,  CNote *n, RECT *rSup)
{

	if(n->m_CenterPoint.m_pdfPage->visible == true)
	{
		long xPos;
		if(n->m_CenterPoint.m_pdfPage->bitmapX>0)
			xPos = - n->m_CenterPoint.m_pdfPage->bitmapX;
		else
			xPos = n->m_CenterPoint.m_pdfPage->screenX;

		long yPos;
		if(n->m_CenterPoint.m_pdfPage->bitmapY>0)
			yPos = - n->m_CenterPoint.m_pdfPage->bitmapY;
		else
			yPos = n->m_CenterPoint.m_pdfPage->screenY;

		rSup->top = yPos +  n->m_CenterPoint.m_p.y - n->m_hNote/2.0;
		rSup->bottom = yPos +  n->m_CenterPoint.m_p.y + n->m_hNote/2.0;
		rSup->left = xPos +  n->m_CenterPoint.m_p.x - n->m_wNote/2;
		rSup->right = xPos +  n->m_CenterPoint.m_p.x + n->m_wNote/2;

		return RectVisible(hdc,rSup);
	}
	else
		return false;

	
}
void CPdfNotes::OnMouseMove(/*WindowInfo *win,*/ int x, int y, WPARAM flags, bool *bForceRepaint)
{
	if(m_pnsCommand == CMD_NEW_UNDERLINE_P2)
	{
		if(m_curULine!=NULL)
		{
			POINT p;
			p.x = x;
			p.y = y;
			PdfPageInfo *pInfo = ConvertPointToPage(m_win, &p);
			if(pInfo!=NULL && pInfo==m_pPageInfoSel)
			{
				if(m_bOrtho == false)
					m_curULine->m_p2.set(p.x, p.y);
				else
				{
					PointD pSup;
					pSup.set(p.x, p.y);

					PointD p2 = CalcolaPointOrtho(m_curULine->m_p1, pSup);
					m_curULine->m_p2.set(p2.x, p2.y);
				}
			}
		}

		m_pnsInAction = true;
		*bForceRepaint = true;
	}
	if(m_pnsCommand == CMD_NEW_HIGHLIGHT_P2)
	{
		if(m_curHLight!=NULL)
		{
			POINT p;
			p.x = x;
			p.y = y;
			PdfPageInfo *pInfo = ConvertPointToPage(m_win, &p);
			if(pInfo!=NULL && pInfo==m_pPageInfoSel)
			{
				PointD pSup;
				pSup.set(p.x, p.y);

				PointD p2 = CalcolaPointOrtho(m_curHLight->m_p1, pSup);
				m_curHLight->m_p2.set(p2.x, p2.y);
			}
		}

		m_pnsInAction = true;
		*bForceRepaint = true;
	}
	else if(m_pnsCommand == CMD_NOTE_MOVE)
	{
		if(m_posNoteSel>-1)
		{
			CNote *n = GetNote(m_posNoteSel);
			if(n!=NULL)
			{
				MoveNote(n, m_win, x, y);

				m_pnsInAction = true;
				*bForceRepaint = true;
			}
		}
	}
	else if(m_pnsCommand == CMD_NEW_CONNECTOR)
	{
		if(m_curConnector >-1 && m_curConnectorLine>-1)
		{
			CConnector *ct = GetConnector(m_curConnector);
			CLine *l = ct->GetLine(m_curConnectorLine);

			CPageLinkedPoint pL = ConvertPointToPageEX(m_win, x, y);

			if(m_bOrtho == false)
			{
				l->m_P2.m_p.x = pL.m_p.x;
				l->m_P2.m_p.y = pL.m_p.y;
				l->m_P2.m_pdfPage = pL.m_pdfPage;
				l->m_P2.m_numPage = pL.m_numPage;
			}
			else
			{
				PointD pSup;
				pSup.x = pL.m_p.x;
				pSup.y = pL.m_p.y;

				PointD p1D (l->m_P1.m_p.x, l->m_P1.m_p.y);
				PointD p2 = CalcolaPointOrtho(p1D, pSup);
				l->m_P2.m_p.x = p2.x;
				l->m_P2.m_p.y = p2.y;
				l->m_P2.m_pdfPage = pL.m_pdfPage;
				l->m_P2.m_numPage = pL.m_numPage;
			}

			m_pnsInAction = true;
			*bForceRepaint = true;
		}
	}
	else if(m_pnsCommand == CMD_CONNECTOR_ANCORAGE_SEL)
	{
		CConnector *ct = GetConnector(m_curConnector);

		CPageLinkedPoint pL = ConvertPointToPageEX(m_win, x, y);

		if(ct->m_1LineSelected < 0 && ct->m_2LineSelected==0)
		{
			//Selected first point of first line
			CLine *line = ct->GetLine(ct->m_2LineSelected);

			line->m_P1.Set(&pL);
		}
		else if(ct->m_1LineSelected == ct->GetNumLines()-1 && ct->m_2LineSelected >= ct->GetNumLines())
		{
			//Selected second point last line
			CLine *line = ct->GetLine(ct->m_1LineSelected);

			line->m_P2.Set(&pL);
		}
		else
		{
			CLine *line = ct->GetLine(ct->m_1LineSelected);

			//ORTHO
			if(m_bOrtho == false)
				line->m_P2.Set(&pL);
			else
			{
				//Ortho ON
				if(line->m_P1.m_pdfPage == pL.m_pdfPage)
				{
					//Point are on same page
					PointD pSup;
					pSup.set( pL.m_p.x, pL.m_p.y);

					PointD p1D (line->m_P1.m_p.x, line->m_P1.m_p.y);
					PointD p2 = CalcolaPointOrtho(p1D, pSup);
					line->m_P2.m_p.x = p2.x;
					line->m_P2.m_p.y = p2.y;
					line->m_P2.m_numPage = pL.m_numPage;
					line->m_P2.m_pdfPage = pL.m_pdfPage;
				}
				else
					line->m_P2.Set(&pL);
			}

			//Second Line
			CLine *line2 = ct->GetLine(ct->m_2LineSelected);

			//ORTHO?
			if(m_bOrtho == false )
				line2->m_P1.Set(&pL);
			else
				line2->m_P1.Set(&(line->m_P2));
		}

		m_pnsInAction = true;
		*bForceRepaint = true;
	}
}

void CPdfNotes::OnMouseLeftButtonDown(/*WindowInfo *win,*/ int x, int y, bool *bForceRepaint)
{
	if(WS_SHOWING_PDF != m_win->state)
		return;

	HCURSOR CursorArrow = LoadCursor(NULL, IDC_ARROW);
	SetCursor(CursorArrow);

	*bForceRepaint = false;


	if(m_pnsCommand == CMD_NEW_UNDERLINE_P1)
	{
		POINT p;
		p.x = x;
		p.y = y;
		m_pPageInfoSel = ConvertPointToPage(m_win, &p);
		if(m_pPageInfoSel!=NULL)
		{
			//Insert a ULine...
			PointD p1(p.x, p.y);
			PointD p2 = p1;
			m_curULine = m_pPageInfoSel->pnElements->AddULine(p1,p2, m_win->dm->zoomReal());
			m_curULine->m_Color = m_ULineColor;

			m_pnsCommand = CMD_NEW_UNDERLINE_P2;
			m_pnsInAction = true;
		}
	}
	else if(m_pnsCommand == CMD_NEW_UNDERLINE_P2)
	{
		m_pPageInfoSel = NULL;
		m_curULine = NULL;
		m_pnsCommand = CMD_NEW_UNDERLINE_P1;
		m_pnsInAction = true;

		*bForceRepaint = true;
	}
	else if(m_pnsCommand == CMD_LINE_SEL)
	{
		if(m_pPageInfoSel != NULL)
		{
			CULine *uL = m_pPageInfoSel->pnElements->GetULine(m_posULineSel);
			uL->m_bIsSelected = false;
			m_pnsInAction = true;
			*bForceRepaint = true;
		}
		m_pnsCommand = CMD_NO_CMD;
	}
	else if(m_pnsCommand == CMD_HIGHLIGHT_SEL)
	{
		if(m_pPageInfoSel != NULL)
		{
			CHighLight *hL = m_pPageInfoSel->pnElements->GetHighLight(m_posHLightSel);
			hL->m_bIsSelected = false;
			m_pnsInAction = true;
			*bForceRepaint = true;
		}
		m_pnsCommand = CMD_NO_CMD;
	}
	else if(m_pnsCommand == CMD_NEW_HIGHLIGHT_P1)
	{
		POINT p;
		p.x = x;
		p.y = y;
		m_pPageInfoSel = ConvertPointToPage(m_win, &p);
		if(m_pPageInfoSel!=NULL)
		{
			//Insert a HLight...
			PointD p1(p.x, p.y);
			PointD p2 = p1;
			m_curHLight = m_pPageInfoSel->pnElements->AddHighLight(p1, p2, m_curHeightPt, m_win->dm->zoomReal());
			m_curHLight->m_bIsSelected = true;

			m_pnsCommand = CMD_NEW_UNDERLINE_P2;
			m_pnsInAction = true;
		}

		m_pnsCommand = CMD_NEW_HIGHLIGHT_P2;
		m_pnsInAction = true;
	}
	else if(m_pnsCommand == CMD_NEW_HIGHLIGHT_P2)
	{
		if(m_curHLight!=NULL)
			m_curHLight->m_bIsSelected = false;

		m_pPageInfoSel = NULL;
		m_curHLight = NULL;
		m_pnsCommand = CMD_NEW_HIGHLIGHT_P1;
		m_pnsInAction = true;

		*bForceRepaint = true;
	}
	else if(m_pnsCommand == CMD_NEW_NOTE)
	{
		CPageLinkedPoint pLinked = ConvertPointToPageEX(m_win, x, y);

		CNoteDlg dlg(IDD_DIALOG_MODNOTE, m_win->hwndCanvas);
		HFONT hfontNotes = CreateFontIndirect(&m_lfNote);
		HFONT hfontForViewNotes = CreateFontIndirect(&m_lfForViewNote);
		dlg.m_hfont = hfontForViewNotes;
		dlg.m_fontColor = m_fontColor;
		dlg.m_hfontNote = hfontNotes;
		dlg.m_fontColorNote = m_fontColor;
		dlg.m_strNote = "";
		if(dlg.DoModal()== TRUE)
		{
			BOOL ret = dlg.m_bOK;
			if(dlg.m_strNote!="")
			{
				//Make RTF rendering
				HBITMAP hbmp = NULL;
				long wNote, hNote;

				PAINTSTRUCT ps;
				HDC hdc = BeginPaint(m_win->hwndCanvas, &ps);
				m_Rtf2Bmp->setZoom(m_win->dm->zoomReal()/100.0);
				hbmp = m_Rtf2Bmp->CreateBMP(dlg.m_strNote, hdc, &wNote, &hNote);
				EndPaint(m_win->hwndCanvas, &ps);

				SizeD dim(wNote, hNote);
				AddNote(pLinked, dim, dlg.m_strNote, hbmp, m_win->dm->zoomReal());

				//Save actual X Coordineta origin
				DisplaySettings *displaySettings = globalDisplaySettings();
				m_xOrigin = displaySettings->paddingPageBorderLeft;

			}
			
			m_pnsInAction = true;
			*bForceRepaint = true;
		}

		dlg.m_hfont = NULL;
		DeleteObject(hfontNotes);

		m_pnsCommand = CMD_NO_CMD;
	}
	else if(m_pnsCommand == CMD_NEW_CONNECTOR)
	{
		if(m_curConnector<0)
		{
			CPageLinkedPoint pL = ConvertPointToPageEX(m_win, x, y);
			NewConnector(m_win, pL);
		}
		else
		{
			CConnector *ct = GetConnector(m_curConnector);
			CLine *l = ct->GetLine(m_curConnectorLine);

			CLine *nl = ct->AddLine(l->m_P2, l->m_P2, l->m_zoom);
			m_curConnectorLine = ct->GetNumLines() -1;
		}
	}
	else if(m_pnsCommand == CMD_NEW_CONNECTOR_END_ON_NOTE)
	{
		CConnector *ct = GetConnector(m_curConnector);
		ct->m_TipoIndicatore =_INDICATORE_FRECCIA_;
		ct->m_PosIndicatore = _POS_INDICATORE_FINE_TRATTO;

		if(IsNoteSelected(m_win, x,y)==true)
		{
			CNote *n = GetNote(m_posNoteSel);
			CPageLinkedPoint pC = n->GetPageLinkedCenterPoint();
			ct->m_StopNotaLinked = n;

			n->m_bIsSelected = false;

			CLine *l = ct->GetLine(m_curConnectorLine);
			l->m_P2.Set(&pC);

			n->AddConnector(ct);

		}

		m_curConnector = -1;
		m_curConnectorLine = -1;
		m_pnsInAction = true;
		*bForceRepaint = true;
		m_pnsCommand = CMD_NO_CMD;
	}
	else if(m_pnsCommand == CMD_CONNECTOR_ANCORAGE_SEL)
	{
		CConnector *ct = GetConnector(m_curConnector);
		ct->m_IsSelected = false;
		ct->m_1LineSelected = -1;
		ct->m_2LineSelected = -1;
		m_curConnector = -1;
		m_pnsCommand = CMD_NO_CMD;
	}
	else if(m_pnsCommand == CMD_CONNECTOR_SEL)
	{
		CConnector *ct = GetConnector(m_curConnector);

		CPageLinkedPoint pL = ConvertPointToPageEX(m_win, x, y);
		if(ct->IsPointInAncorage(m_win, pL) == true)
			m_pnsCommand = CMD_CONNECTOR_ANCORAGE_SEL;
		else
		{
			ct->m_IsSelected = false;
			m_curConnector = -1;
			m_pnsCommand = CMD_NO_CMD;
		}
	}
	else if(m_pnsCommand == CMD_NO_CMD)
	{
		CPageLinkedPoint pL = ConvertPointToPageEX(m_win, x, y);

		//Find if user select a Line
		if(IsULineSelected(m_win, x, y)==true)
			m_pnsCommand = CMD_LINE_SEL;
		else if(IsHighLightSelected(m_win, x, y)==true)
			m_pnsCommand = CMD_HIGHLIGHT_SEL;
		else if(IsNoteSelected(m_win, x, y) == true)
		{
			//set variables for moving
			m_deltaX = (int)(-1e10);
			m_deltaY = (int)(-1e10);

			m_pnsCommand = CMD_NOTE_MOVE;
		}
		else if(IsConnectorSelected(pL) == true)
		{
			CConnector *ct = GetConnector(m_curConnector);
			ct->m_IsSelected = true;
			m_pnsCommand = CMD_CONNECTOR_SEL;
		}

		if(m_pnsCommand != CMD_NO_CMD)
		{
			m_pnsInAction = true;

			*bForceRepaint = true;
		}
		else
			m_pnsInAction = false;
	}
}

void CPdfNotes::OnMouseLeftButtonUp(/*WindowInfo *win,*/ int x, int y, bool *bForceRepaint)
{
	if(m_pnsCommand == CMD_NOTE_MOVE)
	{
		CNote *n = GetNote(m_posNoteSel);
		n->m_bIsSelected = false;
		m_pnsCommand = CMD_NO_CMD;
	}
	else if(m_pnsCommand == CMD_CONNECTOR_ANCORAGE_SEL)
	{
		m_pnsCommand = CMD_CONNECTOR_SEL;
	}
}

static bool IsFilePresent(CString path)
{
	bool ret = false;

	WIN32_FIND_DATA FindFile;
	HANDLE FileHandle = FindFirstFile(path, &FindFile);
	if (FileHandle != INVALID_HANDLE_VALUE)
	{
		FindClose(FileHandle);
		
		//Find files with that name
		ret = true;
	}

	return ret;
}

void CPdfNotes::OnMouseRightButtonDown(/*WindowInfo *win,*/ int x, int y, bool *bForceRepaint)
{
	HCURSOR CursorArrow = LoadCursor(NULL, IDC_ARROW);
	SetCursor(CursorArrow);
	*bForceRepaint = false;

	if(m_win->state != WS_SHOWING_PDF)
		return;

	if(m_bUsePdfNotes == false)
	{
		HMENU hmenu;
		HMENU hmenuTrackPopup;
		hmenu = LoadMenuA(m_hInst, MAKEINTRESOURCE(_POPUP_USE_PDFNOTES_));
		if(hmenu == NULL)
			hmenu = NULL;

		hmenuTrackPopup = GetSubMenu(hmenu, 0); 
 
		RECT rWin;
		GetWindowRect(m_win->hwndCanvas, &rWin);

		int sel = TrackPopupMenu(hmenuTrackPopup, 
								TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, 
								rWin.left + x, rWin.top + y, 0, m_win->hwndCanvas, NULL); 
		switch(sel)
		{
		case ID__USEPDFNOTES:
			{
				//Use Pdf Notes
				m_bUsePdfNotes = true;

				m_win->dm->changeDisplayMode(DM_CONTINUOUS);
				*bForceRepaint = true;
			}
			break;
		}

		return;
	}

	if(m_pnsCommand != CMD_NO_CMD && m_pnsCommand != CMD_LINE_SEL && m_pnsCommand != CMD_NOTE_SEL &&
		m_pnsCommand != CMD_NEW_CONNECTOR && m_pnsCommand != CMD_CONNECTOR_SEL && m_pnsCommand != CMD_HIGHLIGHT_SEL)
		m_pnsCommand = CMD_NO_CMD;
	else if(m_pnsCommand == CMD_LINE_SEL)
	{
		HMENU hmenu;
		HMENU hmenuTrackPopup;
		hmenu = LoadMenuA(m_hInst, MAKEINTRESOURCE(_POPUP_DEL_ULINE_));
		if(hmenu == NULL)
			hmenu = NULL;

		hmenuTrackPopup = GetSubMenu(hmenu, 0); 
 
		RECT rWin;
		GetWindowRect(m_win->hwndCanvas, &rWin);

		int sel = TrackPopupMenu(hmenuTrackPopup, 
								TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, 
								rWin.left + x, rWin.top + y, 0, m_win->hwndCanvas, NULL); 
		switch(sel)
		{
		case ID__DELETE:
			{
				DeleteULineSelected();
				m_pnsInAction = true;
				*bForceRepaint = true;
				m_pnsCommand = CMD_NO_CMD;
			}
			break;
		case ID__COLOR:
			{
				CHOOSECOLOR cc;
				static COLORREF acrCustClr[16]; 

				ZeroMemory(&cc, sizeof(cc));
				cc.lStructSize = sizeof (cc);

				cc.Flags = CC_FULLOPEN | CC_RGBINIT;
				cc.hwndOwner = m_win->hwndCanvas;
				cc.rgbResult = m_ULineColor;
				cc.lpCustColors = (LPDWORD) acrCustClr;

				if(ChooseColor(&cc) == TRUE)
				{
					CULine *uL = m_pPageInfoSel->pnElements->GetULine(m_posULineSel);
					uL->m_Color = cc.rgbResult;
				}

				*bForceRepaint = true;
				m_pnsCommand = CMD_NO_CMD;
			}
			break;

		default:
			{
				if(m_pPageInfoSel != NULL)
				{
					CULine *uL = m_pPageInfoSel->pnElements->GetULine(m_posULineSel);
					uL->m_bIsSelected = false;
					m_pnsInAction = true;
					*bForceRepaint = true;
				}
				m_pnsCommand = CMD_NO_CMD;
			}
		}
	}
	else if(m_pnsCommand == CMD_HIGHLIGHT_SEL)
	{
		HMENU hmenu;
		HMENU hmenuTrackPopup;
		hmenu = LoadMenuA(m_hInst, MAKEINTRESOURCE(_POPUP_DEL_ULINE_));
		if(hmenu == NULL)
			hmenu = NULL;

		hmenuTrackPopup = GetSubMenu(hmenu, 0); 
 
		RECT rWin;
		GetWindowRect(m_win->hwndCanvas, &rWin);

		int sel = TrackPopupMenu(hmenuTrackPopup, 
								TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, 
								rWin.left + x, rWin.top + y, 0, m_win->hwndCanvas, NULL); 
		switch(sel)
		{
		case ID__DELETE:
			{
				DeleteHLightSelected();
				m_pnsInAction = true;
				*bForceRepaint = true;
				m_pnsCommand = CMD_NO_CMD;
			}
			break;
		default:
			{
				if(m_pPageInfoSel != NULL)
				{
					CHighLight *hL = m_pPageInfoSel->pnElements->GetHighLight(m_posHLightSel);
					hL->m_bIsSelected = false;
					m_pnsInAction = true;
					*bForceRepaint = true;
				}
				m_pnsCommand = CMD_NO_CMD;
			}
		}
	}
	else if(m_pnsCommand == CMD_NEW_CONNECTOR)
	{
		HMENU hmenu;
		HMENU hmenuTrackPopup;
		hmenu = LoadMenuA(m_hInst, MAKEINTRESOURCE(_POPUP_END_CONNECTOR));
		if(hmenu == NULL)
			hmenu = NULL;

		hmenuTrackPopup = GetSubMenu(hmenu, 0); 
 
		RECT rWin;
		GetWindowRect(m_win->hwndCanvas, &rWin);

		int sel = TrackPopupMenu(hmenuTrackPopup, 
								TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, 
								rWin.left + x, rWin.top + y, 0, m_win->hwndCanvas, NULL); 
		switch(sel)
		{
		case ID__ENDCONNECTOR:
			{
				//Delete last Line...
				CConnector *ct = GetConnector(m_curConnector);

				if(ct->GetNumLines()>1)
					ct->DeleteLine(m_curConnectorLine);

				ct->m_PosIndicatore = _POS_INDICATORE_FINE_TRATTO;
				ct->m_TipoIndicatore = _INDICATORE_FRECCIA_;
				
				m_curConnector = -1;
				m_curConnectorLine = -1;
				m_pnsInAction = true;
				*bForceRepaint = true;
				m_pnsCommand = CMD_NO_CMD;
			}
			break;
		case ID__ENDCONNECTORONNOTE:
			m_pnsCommand = CMD_NEW_CONNECTOR_END_ON_NOTE;
			break;
		}
	}
	else if(m_pnsCommand == CMD_CONNECTOR_SEL)
	{
		HMENU hmenu;
		HMENU hmenuTrackPopup;
		hmenu = LoadMenuA(m_hInst, MAKEINTRESOURCE(_POPUP_DEL_ULINE_));
		if(hmenu == NULL)
			hmenu = NULL;

		hmenuTrackPopup = GetSubMenu(hmenu, 0); 
 
		RECT rWin;
		GetWindowRect(m_win->hwndCanvas, &rWin);

		int sel = TrackPopupMenu(hmenuTrackPopup, 
								TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, 
								rWin.left + x, rWin.top + y, 0, m_win->hwndCanvas, NULL); 
		switch(sel)
		{
		case ID__DELETE:
			{
				DeleteConnectorSelected();
				m_pnsInAction = true;
				*bForceRepaint = true;
				m_pnsCommand = CMD_NO_CMD;
			}
			break;
		case ID__COLOR:
			{
				CHOOSECOLOR cc;
				static COLORREF acrCustClr[16]; 

				ZeroMemory(&cc, sizeof(cc));
				cc.lStructSize = sizeof (cc);

				cc.Flags = CC_FULLOPEN | CC_RGBINIT;
				cc.hwndOwner = m_win->hwndCanvas;
				cc.rgbResult = m_ConnectorColor;
				cc.lpCustColors = (LPDWORD) acrCustClr;

				if(ChooseColor(&cc) == TRUE)
				{
					CConnector *ct = GetConnector(m_curConnector);
					ct->m_Color = cc.rgbResult;
				}

				*bForceRepaint = true;
				m_pnsCommand = CMD_NO_CMD;
			}
			break;
		}
	}
	else
	{
		//Find if I select a note
		if(IsNoteSelected(m_win, x, y) == true)
		{
			HMENU hmenu;
			HMENU hmenuTrackPopup;
			hmenu = LoadMenuA(m_hInst, MAKEINTRESOURCE(_POPUP_NOTE_SEL_));
			if(hmenu == NULL)
				hmenu = NULL;

			hmenuTrackPopup = GetSubMenu(hmenu, 0); 
	 
			RECT rWin;
			GetWindowRect(m_win->hwndCanvas, &rWin);

			int sel = TrackPopupMenu(hmenuTrackPopup, 
									TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, 
									rWin.left + x, rWin.top + y, 0, m_win->hwndCanvas, NULL); 
			switch(sel)
			{
			case ID__DELETENOTE:
				{
					DeleteNote(m_posNoteSel);
					m_pnsInAction = true;
					*bForceRepaint = true;
					m_pnsCommand = CMD_NO_CMD;
				}
				break;
			case ID__MODIFYNOTE:
				{
					CNote *n = GetNote(m_posNoteSel);
					if(n!=NULL)
					{
/*						strNote = n->m_strNote;

						hwndCanvas = m_win->hwndCanvas;
						bUseDlgForOpenPns = false;
						bUseDlgForZoom = false;
						actualZoom = m_win->dm->zoomReal()/100.0; //(n->m_zoom/n->m_zoomAtIns);
						DialogBox(m_hInst, MAKEINTRESOURCE(IDD_DIALOG_MODNOTE),
							  gHwndEditNote, reinterpret_cast<DLGPROC>(DlgProc));

						if(strNote!="")
							ModifyNote(n, strNote, m_dimMsg, hbmp);

						strNote = "";
						m_pnsInAction = true;
						*bForceRepaint = true;
						m_pnsCommand = CMD_NO_CMD;
*/

						CNoteDlg dlg(IDD_DIALOG_MODNOTE, m_win->hwndCanvas);
						dlg.m_strNote = n->m_strNote;
						HFONT hfont = CreateFontIndirect(&(m_lfForViewNote));
						dlg.m_hfont = hfont;
						dlg.m_fontColor = m_fontColor;
						HFONT hfontNote = CreateFontIndirect(&(n->m_lfNote));
						dlg.m_hfontNote = hfontNote;
						dlg.m_fontColorNote = n->m_fontColor;
						if(dlg.DoModal()== TRUE)
						{
							BOOL ret = dlg.m_bOK;
							if(dlg.m_strNote!="")
							{
								//Make RTF rendering
								HBITMAP hbmp = NULL;
								long wNote, hNote;

								PAINTSTRUCT ps;
								HDC hdc = BeginPaint(m_win->hwndCanvas, &ps);
								m_Rtf2Bmp->setZoom(m_win->dm->zoomReal()/100.0);
								hbmp = m_Rtf2Bmp->CreateBMP(dlg.m_strNote, hdc, &wNote, &hNote);
								EndPaint(m_win->hwndCanvas, &ps);

								SizeD dim((double) wNote, (double) hNote);
								ModifyNote(n, dlg.m_strNote, dim, hbmp);

								m_pnsInAction = true;
								*bForceRepaint = true;
								m_pnsCommand = CMD_NO_CMD;
							}
						}

						dlg.m_hfont = NULL;
						DeleteObject(hfont);

						dlg.m_hfontNote = NULL;
						DeleteObject(hfontNote);
					}
				}
				break;
			case ID__CONNECTOR:
				{
					CPageLinkedPoint pL;
					NewConnector(m_win, pL);

					CNote *n = GetNote(m_posNoteSel);
					n->m_bIsSelected = false;

					m_pnsCommand = CMD_NEW_CONNECTOR;
					m_pnsInAction = true;
					*bForceRepaint = true;
				}
				break;
			case ID_OPTIONS_FONT:
				{
					CHOOSEFONT cf;				// common dialog box structure
					static DWORD rgbCurrent;	// current text color
					HFONT hfont;

					CNote *n = GetNote(m_posNoteSel);

					// Initialize CHOOSEFONT
					ZeroMemory(&cf, sizeof(CHOOSEFONT));
					cf.lStructSize = sizeof (CHOOSEFONT);
					cf.hwndOwner = m_win->hwndCanvas;
					cf.lpLogFont = &(n->m_lfNote);
					cf.rgbColors = n->m_fontColor;
					cf.Flags = CF_SCREENFONTS | CF_EFFECTS | CF_INITTOLOGFONTSTRUCT ;

					//Chose a font
					if (ChooseFont(&cf)==TRUE) 
					{
						hfont = CreateFontIndirect(cf.lpLogFont);

						ModifyFontNotes(m_posNoteSel, hfont, cf.rgbColors);

						DeleteObject(hfont);

						n->m_fontColor = cf.rgbColors;

						m_pnsInAction = true;
						*bForceRepaint = true;
					}
				}
				break;
			default:
				{
					m_pnsCommand = CMD_NO_CMD;
				}
			}
		}
		else
		{
			HMENU hmenu;
			HMENU hmenuTrackPopup;
			hmenu = LoadMenuA(m_hInst, MAKEINTRESOURCE(_POPUP_PDFNOTES_));
			if(hmenu == NULL)
				hmenu = NULL;

			hmenuTrackPopup = GetSubMenu(hmenu, 0); 
	 
			if(m_bOrtho)
				CheckMenuItem(hmenu, ID__ORTHO, MF_BYCOMMAND | MF_CHECKED);
			else
				CheckMenuItem(hmenu, ID__ORTHO, MF_BYCOMMAND | MF_UNCHECKED);

			//Select cur Height of HeighLight
			SelectCurHeightHighLight(hmenu);

			RECT rWin;
			GetWindowRect(m_win->hwndCanvas, &rWin);

			int sel = TrackPopupMenu(hmenuTrackPopup, 
									TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, 
									rWin.left + x, rWin.top + y, 0, m_win->hwndCanvas, NULL); 
			switch(sel)
			{
				case ID_FILE_OPEN:
					{
						OPENFILENAME ofn = {0};
						char         fileName[260];

						ofn.lStructSize = sizeof(ofn);
						ofn.hwndOwner = m_win->hwndFrame;
						ofn.lpstrFile = fileName;

						// Set lpstrFile[0] to '\0' so that GetOpenFileName does not
						// use the contents of szFile to initialize itself.
						ofn.lpstrFile[0] = '\0';
						ofn.nMaxFile = sizeof(fileName);
						ofn.lpstrFilter = "PNS\0*.pns\0All\0*.*\0";
						ofn.nFilterIndex = 1;
						ofn.lpstrFileTitle = NULL;
						ofn.nMaxFileTitle = 0;
						ofn.lpstrInitialDir = NULL;
						ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

						if (FALSE == GetOpenFileName(&ofn))
							return;

						char* realDstFileName = fileName;
						if (!str_endswithi(fileName, ".pns")) {
							realDstFileName = str_cat(fileName, ".pns");
						}

						strcpy_s(PNSFileName, realDstFileName);
						OpenPNS(realDstFileName, m_win);

						m_pnsInAction = true;
					}
					break;
				case ID_FILE_SAVE:
					{
						if(IsFilePresent(PNSFileName)==false)
						{
							OPENFILENAME ofn = {0};
							char         dstFileName[MAX_PATH] = {0};
							const char*  srcFileName = NULL;

							assert(m_win);
							if (!m_win) return;
							assert(m_win->dm);
							if (!m_win->dm) return;

							srcFileName = "";
							assert(srcFileName);
							if (!srcFileName) return;

							ofn.lStructSize = sizeof(ofn);
							ofn.hwndOwner = m_win->hwndFrame;
							ofn.lpstrFile = dstFileName;

							// Set lpstrFile[0] to '\0' so that GetOpenFileName does not
							// use the contents of szFile to initialize itself.
							ofn.lpstrFile[0] = '\0';
							ofn.nMaxFile = dimof(dstFileName);
							ofn.lpstrFilter = "PNS\0*.pns\0All\0*.*\0";
							ofn.nFilterIndex = 1;
							ofn.lpstrFileTitle = NULL;
							ofn.nMaxFileTitle = 0;
							ofn.lpstrInitialDir = NULL;
							ofn.Flags = OFN_SHOWHELP | OFN_OVERWRITEPROMPT;

							if (FALSE == GetSaveFileName(&ofn))
								return;

							strcpy_s(PNSFileName, dstFileName);
							if (!str_endswithi(dstFileName, ".pns")) 
							{
								char * supFileName = str_cat(dstFileName, ".pns");
								strcpy_s(PNSFileName, supFileName);
							}
						}

						SavePNS(PNSFileName, m_win);

						m_pnsInAction = true;
					}
					break;
				case ID_FILE_SAVEAS:
					{
						OPENFILENAME ofn = {0};
						char         dstFileName[MAX_PATH] = {0};
						const char*  srcFileName = NULL;

						assert(m_win);
						if (!m_win) return;
						assert(m_win->dm);
						if (!m_win->dm) return;

						srcFileName = "";
						assert(srcFileName);
						if (!srcFileName) return;

						ofn.lStructSize = sizeof(ofn);
						ofn.hwndOwner = m_win->hwndFrame;
						ofn.lpstrFile = dstFileName;

						// Set lpstrFile[0] to '\0' so that GetOpenFileName does not
						// use the contents of szFile to initialize itself.
						ofn.lpstrFile[0] = '\0';
						ofn.nMaxFile = dimof(dstFileName);
						ofn.lpstrFilter = "PNS\0*.pns\0All\0*.*\0";
						ofn.nFilterIndex = 1;
						ofn.lpstrFileTitle = NULL;
						ofn.nMaxFileTitle = 0;
						ofn.lpstrInitialDir = NULL;
						ofn.Flags = OFN_SHOWHELP | OFN_OVERWRITEPROMPT;

						if (FALSE == GetSaveFileName(&ofn))
							return;

						strcpy_s(PNSFileName, dstFileName);
						if (!str_endswithi(dstFileName, ".pns")) 
						{
							char * supFileName = str_cat(dstFileName, ".pns");
							strcpy_s(PNSFileName, supFileName);
						}

						SavePNS(PNSFileName, m_win);

						m_pnsInAction = true;
					}
					break;
				case ID__UNDERLINE:
					m_pnsCommand = CMD_NEW_UNDERLINE_P1;
					m_pnsInAction = true;
					break;
				case ID__ORTHO:
					m_bOrtho = ! m_bOrtho;
					m_pnsInAction = true;
					break;
				case ID__NOTE:
					m_pnsCommand = CMD_NEW_NOTE;
					m_pnsInAction = true;
					break;
				case ID__CONNECTOR:
					m_pnsCommand = CMD_NEW_CONNECTOR;
					m_pnsInAction = true;
					m_posNoteSel = -1;
					break;
				case ID__HIGHLINGHT:
					m_pnsCommand = CMD_NEW_HIGHLIGHT_P1;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_8PT:
					m_curHeightPt = _HEIGHT_8PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_9PT:
					m_curHeightPt = _HEIGHT_9PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_10PT:
					m_curHeightPt = _HEIGHT_10PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_11PT:
					m_curHeightPt = _HEIGHT_11PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_12PT:
					m_curHeightPt = _HEIGHT_12PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_13PT:
					m_curHeightPt = _HEIGHT_13PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_14PT:
					m_curHeightPt = _HEIGHT_14PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_15PT:
					m_curHeightPt = _HEIGHT_15PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_16PT:
					m_curHeightPt = _HEIGHT_16PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_17PT:
					m_curHeightPt = _HEIGHT_17PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_18PT:
					m_curHeightPt = _HEIGHT_18PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_19PT:
					m_curHeightPt = _HEIGHT_19PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_HEIGHT_20PT:
					m_curHeightPt = _HEIGHT_20PT;
					m_pnsCommand = CMD_NO_CMD;
					m_pnsInAction = true;
					break;
				case ID_OPTIONS_NOTE_FONT:
					{
						//Modify NOTE font
						CHOOSEFONT cf;				// common dialog box structure
						static DWORD rgbCurrent;	// current text color

						// Initialize CHOOSEFONT
						ZeroMemory(&cf, sizeof(CHOOSEFONT));
						cf.lStructSize = sizeof (CHOOSEFONT);
						cf.hwndOwner = m_win->hwndCanvas;
						cf.lpLogFont = &(m_lfNote);
						cf.rgbColors = m_fontColor;
						cf.Flags = CF_SCREENFONTS | CF_EFFECTS | CF_INITTOLOGFONTSTRUCT ;

						//Chose a font
						if(ChooseFont(&cf)==TRUE)
						{
							m_fontColor = cf.rgbColors;
						}
					}
					break;
				case ID_OPTIONS_ULINE_COLOR:
					{
						CHOOSECOLOR cc;
						static COLORREF acrCustClr[16]; 

						ZeroMemory(&cc, sizeof(cc));
						cc.lStructSize = sizeof (cc);

						cc.Flags = CC_FULLOPEN | CC_RGBINIT;
						cc.hwndOwner = m_win->hwndCanvas;
						cc.rgbResult = m_ULineColor;
						cc.lpCustColors = (LPDWORD) acrCustClr;

						if(ChooseColor(&cc)==TRUE)
							m_ULineColor = cc.rgbResult;

					}
					break;
				case ID_OPTIONS_CONNECTOR_COLOR:
					{
						CHOOSECOLOR cc;
						static COLORREF acrCustClr[16]; 

						ZeroMemory(&cc, sizeof(cc));
						cc.lStructSize = sizeof (cc);

						cc.Flags = CC_FULLOPEN | CC_RGBINIT;
						cc.hwndOwner = m_win->hwndCanvas;
						cc.rgbResult = m_ConnectorColor;
						cc.lpCustColors = (LPDWORD) acrCustClr;

						if(ChooseColor(&cc)==TRUE)
							m_ConnectorColor = cc.rgbResult;

					}
					break;
				case ID__UNLOADPDFNOTES1:
					m_bUsePdfNotes = false;
					m_pnsCommand = CMD_NO_CMD;
					*bForceRepaint = true;
					m_pnsInAction = true;
			};
			DestroyMenu(hmenu); 
		}
	}
}

void CPdfNotes::OnMouseLeftButtonDblClick(/*WindowInfo *win,*/ int x, int y, bool *bForceRepaint)
{
	//Nothing
}

void CPdfNotes::SelectCurHeightHighLight(HMENU hmenu)
{
	switch(m_curHeightPt)
	{
	case _HEIGHT_8PT:
		CheckMenuItem(hmenu, ID_HEIGHT_8PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_9PT:
		CheckMenuItem(hmenu, ID_HEIGHT_9PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_10PT:
		CheckMenuItem(hmenu, ID_HEIGHT_10PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_11PT:
		CheckMenuItem(hmenu, ID_HEIGHT_11PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_12PT:
		CheckMenuItem(hmenu, ID_HEIGHT_12PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_13PT:
		CheckMenuItem(hmenu, ID_HEIGHT_13PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_14PT:
		CheckMenuItem(hmenu, ID_HEIGHT_14PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_15PT:
		CheckMenuItem(hmenu, ID_HEIGHT_15PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_16PT:
		CheckMenuItem(hmenu, ID_HEIGHT_16PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_17PT:
		CheckMenuItem(hmenu, ID_HEIGHT_17PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_18PT:
		CheckMenuItem(hmenu, ID_HEIGHT_18PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_19PT:
		CheckMenuItem(hmenu, ID_HEIGHT_19PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	case _HEIGHT_20PT:
		CheckMenuItem(hmenu, ID_HEIGHT_20PT, MF_BYCOMMAND | MF_CHECKED);
		break;
	}
}

void CPdfNotes::DeleteULineSelected()
{
	if(m_pPageInfoSel != NULL)
	{
		m_pPageInfoSel->pnElements->DeleteULine(m_posULineSel);
	}
}

void CPdfNotes::DeleteHLightSelected()
{
	if(m_pPageInfoSel != NULL)
	{
		m_pPageInfoSel->pnElements->DeleteHighLight(m_posHLightSel);
	}
}

PdfPageInfo* CPdfNotes::ConvertPointToPage (WindowInfo *win, POINT *p)
{
    RectI pageOnScreen;
	PdfPageInfo *pInfo = NULL;

    for (int pageNo = win->dm->pageCount(); pageNo >= 1; --pageNo) {
        PdfPageInfo *pageInfo = win->dm->getPageInfo(pageNo);
        if (!pageInfo->visible)
            continue;
        assert(pageInfo->shown);
        if (!pageInfo->shown)
            continue;

        pageOnScreen.x = pageInfo->screenX;
        pageOnScreen.y = pageInfo->screenY;
        pageOnScreen.dx = pageInfo->bitmapDx;
        pageOnScreen.dy = pageInfo->bitmapDy;

		RECT r;
		r.left = pageOnScreen.x;
		r.right = pageOnScreen.x + pageOnScreen.dx;
		r.top = pageOnScreen.y;
		r.bottom = pageOnScreen.y + pageOnScreen.dy;

		if(PtInRect(&r, *p) == TRUE )
		{
			PointD p1L, p2L;
			p->x = p->x - r.left + pageInfo->bitmapX;
			p->y = p->y - r.top + pageInfo->bitmapY;
			
			pInfo = pageInfo;
			break;
		}
    }

	return pInfo;
}

PdfPageInfo* CPdfNotes::ConvertPointToPageEX (WindowInfo *win, POINT *p, int *numPage)
{
    RectI pageOnScreen;
	PdfPageInfo *pInfo = NULL;

    for (int pageNo = win->dm->pageCount(); pageNo >= 1; --pageNo) {
        PdfPageInfo *pageInfo = win->dm->getPageInfo(pageNo);
        if (!pageInfo->visible)
            continue;
        assert(pageInfo->shown);
        if (!pageInfo->shown)
            continue;

        pageOnScreen.x = pageInfo->screenX;
        pageOnScreen.y = pageInfo->screenY;
        pageOnScreen.dx = pageInfo->bitmapDx;
        pageOnScreen.dy = pageInfo->bitmapDy;

		RECT r;
		r.left = pageOnScreen.x;
		r.right = pageOnScreen.x + pageOnScreen.dx;
		r.top = pageOnScreen.y;
		r.bottom = pageOnScreen.y + pageOnScreen.dy;

		int yMin, yMax;
		if(pageNo == 1)
			yMin = pageOnScreen.y - globalDisplaySettings()->paddingPageBorderTop;
		else
			yMin = pageOnScreen.y - globalDisplaySettings()->paddingBetweenPagesY;

		if(pageNo == win->dm->pageCount())
			yMax = pageOnScreen.y + pageOnScreen.dy + globalDisplaySettings()->paddingPageBorderBottom;
		else
			yMax = pageOnScreen.y + pageOnScreen.dy + globalDisplaySettings()->paddingBetweenPagesY;


		if(p->y > yMin && p->y < yMax)
		{
			PointD p1L, p2L;
			p->x = p->x - r.left + pageInfo->bitmapX;
			p->y = p->y - r.top + pageInfo->bitmapY;
			
			pInfo = pageInfo;

			if(numPage!=NULL)
				*numPage = pageNo;

			break;
		}
    }

	return pInfo;
}

CPageLinkedPoint CPdfNotes::ConvertPointToPageEX (WindowInfo *win, int x, int y)
{
	CPageLinkedPoint pRet;

    RectI pageOnScreen;
	PdfPageInfo *pInfo = NULL;

    for (int pageNo = win->dm->pageCount(); pageNo >= 1; --pageNo) {
        PdfPageInfo *pageInfo = win->dm->getPageInfo(pageNo);
        if (!pageInfo->visible)
            continue;
        assert(pageInfo->shown);
        if (!pageInfo->shown)
            continue;

        pageOnScreen.x = pageInfo->screenX;
        pageOnScreen.y = pageInfo->screenY;
        pageOnScreen.dx = pageInfo->bitmapDx;
        pageOnScreen.dy = pageInfo->bitmapDy;

		RECT r;
		r.left = pageOnScreen.x;
		r.right = pageOnScreen.x + pageOnScreen.dx;
		r.top = pageOnScreen.y;
		r.bottom = pageOnScreen.y + pageOnScreen.dy;

		int yMin, yMax;
		if(pageNo == 1)
			yMin = pageOnScreen.y - globalDisplaySettings()->paddingPageBorderTop;
		else
			yMin = pageOnScreen.y - globalDisplaySettings()->paddingBetweenPagesY;

		if(pageNo == win->dm->pageCount())
			yMax = pageOnScreen.y + pageOnScreen.dy + globalDisplaySettings()->paddingPageBorderBottom;
		else
			yMax = pageOnScreen.y + pageOnScreen.dy + globalDisplaySettings()->paddingBetweenPagesY;


		if(y > yMin && y < yMax)
		{
			POINT p;
			p.x = x - r.left + pageInfo->bitmapX;
			p.y = y - r.top + pageInfo->bitmapY;
			
			pRet.m_numPage = pageNo;
			pRet.m_p.set(p.x, p.y);
			pRet.m_pdfPage = pageInfo;

			break;
		}
    }

	return pRet;
}

PointD CPdfNotes::CalcolaPointOrtho(PointD pPrec, PointD pCur)
{
	PointD pRet;

	double Angolo = GetAngoloFromPoints(pPrec,pCur);
	double Distanza = sqrt(powl((pPrec.x - pCur.x),2) + powl((pPrec.y - pCur.y),2));
	Angolo = Multiplo45(Angolo);
	pRet.x = pPrec.x + (int)(Distanza * cos(Angolo));
	pRet.y = pPrec.y + (int)(Distanza * sin(Angolo));

	return pRet;
}


void CPdfNotes::VerifyDrawingArea(WindowInfo *win, int x, int y)
{
	RECT rClient;
	GetClientRect(win->hwndCanvas, &rClient);

	double xStart, xStop;
	xStart=0.0;
	xStop = 0.0;

    for (int pageNo = win->dm->pageCount(); pageNo >= 1; --pageNo) 
	{
        PdfPageInfo *pageInfo = win->dm->getPageInfo(pageNo);
        if (!pageInfo->visible)
            continue;
        assert(pageInfo->shown);
        if (!pageInfo->shown)
            continue;

		if(pageInfo->screenX > xStart)
		{
			xStart = pageInfo->screenX;
			xStop = pageInfo->screenX + pageInfo->bitmapDx;
		}
	}

	if(xStart>0 && xStop>0)
	{
		DisplaySettings *displaySettings = globalDisplaySettings();
		if(xStart > displaySettings->paddingPageBorderLeft)
		{
			displaySettings->paddingPageBorderLeft = xStart;
			displaySettings->paddingPageBorderRight = xStart;
		}
	}
}

void CPdfNotes::VerifyDrawingArea(DisplayModel *dm)
{
	double xStart, xStop;
	xStart=0.0;
	xStop = 0.0;

    for (int pageNo = dm->pageCount(); pageNo >= 1; --pageNo) 
	{
        PdfPageInfo *pageInfo = dm->getPageInfo(pageNo);
        if (!pageInfo->visible)
            continue;
        assert(pageInfo->shown);
        if (!pageInfo->shown)
            continue;

		if(pageInfo->screenX > xStart)
		{
			xStart = pageInfo->screenX;
			xStop = pageInfo->screenX + pageInfo->bitmapDx;
		}
	}

	if(xStart>0 && xStop>0)
	{
		DisplaySettings *displaySettings = globalDisplaySettings();
		if(xStart > displaySettings->paddingPageBorderLeft)
		{
			displaySettings->paddingPageBorderLeft = xStart;
			displaySettings->paddingPageBorderRight = xStart;
		}
	}
}

bool CPdfNotes::IsULineSelected(WindowInfo *win, int x, int y)
{
	bool ret = false;
    RectI pageOnScreen;

    for (int pageNo = win->dm->pageCount(); pageNo >= 1; --pageNo) {
        PdfPageInfo *pageInfo = win->dm->getPageInfo(pageNo);
        if (!pageInfo->visible)
            continue;
        assert(pageInfo->shown);
        if (!pageInfo->shown)
            continue;

		if(pageInfo->pnElements->HasElements() == false)
			continue;

        pageOnScreen.x = pageInfo->screenX;
        pageOnScreen.y = pageInfo->screenY;
        pageOnScreen.dx = pageInfo->bitmapDx;
        pageOnScreen.dy = pageInfo->bitmapDy;

		RECT r;
		r.left = pageOnScreen.x;
		r.right = pageOnScreen.x + pageOnScreen.dx;
		r.top = pageOnScreen.y;
		r.bottom = pageOnScreen.y + pageOnScreen.dy;

		POINT p;
		p.x = x;
		p.y = y;

		if(PtInRect(&r, p) == TRUE)
		{
			PointD p1;
			p1.x = p.x - r.left + pageInfo->bitmapX;
			p1.y = p.y - r.top + pageInfo->bitmapY;

			//Ciclo sugli elementi
			for(int j=0; j<pageInfo->pnElements->m_numLines; j++)
			{
				CULine *uL = pageInfo->pnElements->GetULine(j);
				if(IsPointNearLine(uL->m_p1, uL->m_p2, p1) == TRUE)
				{
					m_pPageInfoSel = pageInfo;
					m_posULineSel = j;

					uL->m_bIsSelected = true;

					ret = true;
				}
			}
		}
    }

	return ret;
}

bool CPdfNotes::IsHighLightSelected(WindowInfo *win, int x, int y)
{
	bool ret = false;
    RectI pageOnScreen;

    for (int pageNo = win->dm->pageCount(); pageNo >= 1; --pageNo) {
        PdfPageInfo *pageInfo = win->dm->getPageInfo(pageNo);
        if (!pageInfo->visible)
            continue;
        assert(pageInfo->shown);
        if (!pageInfo->shown)
            continue;

		if(pageInfo->pnElements->HasElements() == false)
			continue;

        pageOnScreen.x = pageInfo->screenX;
        pageOnScreen.y = pageInfo->screenY;
        pageOnScreen.dx = pageInfo->bitmapDx;
        pageOnScreen.dy = pageInfo->bitmapDy;

		RECT r;
		r.left = pageOnScreen.x;
		r.right = pageOnScreen.x + pageOnScreen.dx;
		r.top = pageOnScreen.y;
		r.bottom = pageOnScreen.y + pageOnScreen.dy;

		POINT p;
		p.x = x;
		p.y = y;

		if(PtInRect(&r, p) == TRUE)
		{
			POINT p1;
			p1.x = p.x - r.left + pageInfo->bitmapX;
			p1.y = p.y - r.top + pageInfo->bitmapY;

			//Cicle on elements
			for(int j=0; j<pageInfo->pnElements->m_numHLight; j++)
			{
				CHighLight *hL = pageInfo->pnElements->GetHighLight(j);
				RECT rH = hL->GetRect();
				if(PtInRect(&rH, p1) == TRUE)
				{
					m_pPageInfoSel = pageInfo;
					m_posHLightSel = j;

					hL->m_bIsSelected = true;

					ret = true;
				}
			}
		}
    }

	return ret;
}

CNote* CPdfNotes::AddNote(CPageLinkedPoint p, SizeD dimension , CString str, HBITMAP bmp, double zoom)
{
	//New note
	CNote *n;

	n = new CNote();
	n->m_strNote = str;
	n->m_zoom = zoom;
	n->m_lfNote = m_lfNote;
	n->m_fontColor = m_fontColor;
	n->m_CenterPoint.Set(&p);
	n->m_hNote = dimension.dy();
	n->m_wNote = dimension.dx();

	//La bitmap
	if(bmp != NULL)
	{
		BITMAP BitmapInfo;
		GetObject(bmp, sizeof(BITMAP), &BitmapInfo);
		BitmapInfo.bmBits = new BYTE[BitmapInfo.bmWidthBytes*BitmapInfo.bmHeight];
		GetBitmapBits(bmp,BitmapInfo.bmWidthBytes*BitmapInfo.bmHeight, BitmapInfo.bmBits);

		n->m_hBmp = CreateBitmapIndirect(&BitmapInfo);

		delete[] BitmapInfo.bmBits; 
	}

	m_notes = (CNote **)greallocn(m_notes, m_numNotes+1, sizeof(CNote *));
	m_notes[m_numNotes] = n;
	m_numNotes++;

	n->m_connectors = NULL;
	n->m_pLoadedConnectors = NULL;

	return n;
}

void CPdfNotes::ModifyNote(CNote *n, CString str, SizeD dimension, HBITMAP bmp)
{
	//The string
	n->m_strNote = str;

	//I Modify width and height on note
	n->m_wNote = dimension.dx();
	n->m_hNote = dimension.dy();

	//Bitmap
	BITMAP BitmapInfo;
	GetObject(bmp, sizeof(BITMAP), &BitmapInfo);
	BitmapInfo.bmBits = new BYTE[BitmapInfo.bmWidthBytes*BitmapInfo.bmHeight];
	GetBitmapBits(bmp,BitmapInfo.bmWidthBytes*BitmapInfo.bmHeight, BitmapInfo.bmBits);

	n->m_hBmp = CreateBitmapIndirect(&BitmapInfo);

	delete[] BitmapInfo.bmBits; 

}

void CPdfNotes::DeleteNote(int pos)
{
	CNote *n = m_notes[pos];

	//Delete connector linked to note
	int nConnectors = n->GetNumConnectors();
	for(int i=0;i<nConnectors;i++)
	{
		CConnector *ct = n->GetConnector(0);

		for(int k=0; k<m_numConnectors; k++)
		{
			CConnector *ct1 = GetConnector(k);
			if(ct1 == ct)
			{
				//Erase connector ref. from the notes that links
				CNote *n1 = NULL;
				if(ct1->m_StartNotaLinked!= n && ct1->m_StartNotaLinked != NULL)
					n1 = ct1->m_StartNotaLinked;
				else if(ct1->m_StopNotaLinked != n && ct1->m_StopNotaLinked != NULL)
					n1 = ct1->m_StopNotaLinked;

				if(n1!=NULL)
				{
					for(int j=0;j<n1->GetNumConnectors();j++)
					{
						CConnector *ct2 = n1->GetConnector(j);
						if(ct2 == ct)
						{
							n1->DeleteConnector(j);
							break;
						}
					}
				}

				//Delete connector
				DeleteConnector(k);

				//Delete ref to connector
				n->DeleteConnector(0);
			}
		}
	}

	//Repositioning elements
	if(pos<m_numNotes)
	{
		for(int i=pos+1; i<m_numNotes;i++)
		{
			CNote *ncurr = m_notes[i];
			m_notes[i-1] = ncurr;
		}

		//Delete last line
		m_notes[m_numNotes-1] = NULL;
	}

	delete n;
	m_numNotes--;
}

void CPdfNotes::DeleteConnectorSelected()
{
	CConnector *ct = GetConnector(m_curConnector);

	//Delete reference element in the note
	if(ct->m_StartNotaLinked!=NULL)
	{
		CNote *n = ct->m_StartNotaLinked;
		for(int i=0; i<n->GetNumConnectors(); i++)
		{
			CConnector *ct1 = n->GetConnector(i);
			if(ct == ct1)
			{
				n->DeleteConnector(i);
				break;
			}
		}
	}

	if(ct->m_StopNotaLinked!=NULL)
	{
		CNote *n = ct->m_StopNotaLinked;
		for(int i=0; i<n->GetNumConnectors(); i++)
		{
			CConnector *ct1 = n->GetConnector(i);
			if(ct == ct1)
			{
				n->DeleteConnector(i);
				break;
			}
		}
	}

	//Delete connector
	DeleteConnector(m_curConnector);
	m_curConnector = -1;
}

CNote* CPdfNotes::GetNote(int i)
{
	if(i<0)
		return NULL;
	else
		return m_notes[i];
}

long CPdfNotes::GetNumNote()
{
	return m_numNotes;
}

bool CPdfNotes::IsNoteSelected(WindowInfo *win, int x, int y)
{
	bool ret = false;

	POINT p; 
	p.x = x; 
	p.y = y;

	for(int i=0;i<m_numNotes;i++)
	{
		CNote *n = GetNote(i);

		long w = n->m_wNote; // n->m_rNote.right - n->m_rNote.left;
		long h = n->m_hNote; // n->m_rNote.bottom - n->m_rNote.top;

		if(n->m_CenterPoint.m_pdfPage->visible == true)
		{
			RECT rSup;

			long xPos;
			if(n->m_CenterPoint.m_pdfPage->bitmapX>0)
				xPos = - n->m_CenterPoint.m_pdfPage->bitmapX;
			else
				xPos = n->m_CenterPoint.m_pdfPage->screenX;

			long yPos;
			if(n->m_CenterPoint.m_pdfPage->bitmapY>0)
				yPos = - n->m_CenterPoint.m_pdfPage->bitmapY;
			else
				yPos = n->m_CenterPoint.m_pdfPage->screenY;

			rSup.top = yPos +  n->m_CenterPoint.m_p.y - h/2;
			rSup.bottom = yPos +  n->m_CenterPoint.m_p.y + h/2;
			rSup.left = xPos +  n->m_CenterPoint.m_p.x - w/2;
			rSup.right = xPos +  n->m_CenterPoint.m_p.x + w/2;

			if(PtInRect(&(rSup), p) == TRUE)
			{
				ret = TRUE;
				m_posNoteSel = i;
				n->m_bIsSelected = true;
				break;
			}
		}
		
	}

	return ret;
}

void CPdfNotes::ModifyFontNotes(int posNote, HFONT hfont, COLORREF color)
{
	CNote *n = GetNote(posNote);
	if(n)
	{
		PAINTSTRUCT ps;
		HDC hdc = BeginPaint(m_win->hwndCanvas, &ps);

		long w,h;
		HBITMAP bmp = m_Rtf2Bmp->ModifyFontRTF(hdc, n->m_strNote, hfont, color, &w, &h);

		//Modify the notes
		CString str;
		m_Rtf2Bmp->get_RTFText(&str);

		SizeD dim((double)w, (double)h);
		ModifyNote(n, str, dim, bmp);

		EndPaint(m_win->hwndCanvas, &ps);
	}
}

bool CPdfNotes::IsConnectorSelected(CPageLinkedPoint pIns)
{
	bool ret = false;

	bool find = false;
	for(int i=0; i<GetNumConnectors(); i++)
	{
		CConnector *ct = GetConnector(i);
		for(int k=0; k<ct->GetNumLines(); k++)
		{
			CLine *l = ct->GetLine(k);
			PointD p1Line;
			PointD p2Line;
			PointD p;
			
			if(l->m_P1.m_pdfPage == l->m_P2.m_pdfPage)
			{
				p1Line = l->m_P1.m_p;
				p2Line = l->m_P2.m_p;
				p = pIns.m_p;
			}
			else
			{
				//Convert  to win
				POINT p1,p2,pi;
				ConvertPointToWinEX(l->m_P1, &p1, m_win);
				ConvertPointToWinEX(l->m_P2, &p2, m_win);
				ConvertPointToWinEX(pIns, &pi, m_win);

				p1Line.set(p1.x,p1.y);
				p2Line.set(p2.x,p2.y);
				p.set(pi.x, pi.y);
			}

			if(IsPointNearLine(p1Line, p2Line, p)== TRUE)
			{
				m_curConnector = i;
				find = true;
				ret = true;
				break;
			}

			if(find==true)
				break;
		}
	}

	return ret;
}


static long CalcYPosition(int yPos, DisplayModel *dm, double Zoom)
{
	double YRet = 0;
	double yCurPos = 6;
	double deltaZoom = 0.0;
	int curPage = 0;

	for(int pageNo=1; pageNo<=dm->pageCount(); pageNo++)
	{
		double h = 0.0;
		h = dm->getPageInfo(pageNo)->currOldDy + 12.0;
		yCurPos = yCurPos + h;
		if(yCurPos >= yPos)
		{
			deltaZoom = yPos - (yCurPos - h);
			curPage = pageNo;
			break;
		}
	}

	if(curPage >0)
	{
		YRet = dm->getPageInfo(curPage)->currPosY + deltaZoom * Zoom;
	}

	return (long)(YRet);
}

void CPdfNotes::RecalcNotesPosition(double newZoom, DisplaySettings *displaySettings, DisplayModel *dm)
{
	int left = displaySettings->paddingPageBorderLeft;

	for(int i=0;i<m_numNotes;i++)
	{
		CNote *n = GetNote(i);
		double z = newZoom / n->m_zoom;
		double z1 = newZoom/100.0;

		if(n->m_zoom == newZoom)
			continue;

		//Modify Note X position
		if(n->m_CenterPoint.m_p.x <0){/*Do nothing*/}
		else
		{
			if(n->m_CenterPoint.m_p.x <= n->m_CenterPoint.m_pdfPage->currOldDx)
				n->m_CenterPoint.m_p.x = (n->m_CenterPoint.m_p.x)*z;
			else
			{
				double deltaNoZoom = n->m_CenterPoint.m_p.x - n->m_CenterPoint.m_pdfPage->currOldDx;
				n->m_CenterPoint.m_p.x = n->m_CenterPoint.m_pdfPage->currDx + deltaNoZoom;
			}
		}

		//Modify Note Y position
		if(n->m_CenterPoint.m_p.y <0){/*Do nothing*/}
		else
		{
			if(n->m_CenterPoint.m_p.y < n->m_CenterPoint.m_pdfPage->currOldDy)
				n->m_CenterPoint.m_p.y = (n->m_CenterPoint.m_p.y)*z;
			else
			{
				double deltaNoZoom = n->m_CenterPoint.m_p.y - n->m_CenterPoint.m_pdfPage->currOldDy;
				n->m_CenterPoint.m_p.y = n->m_CenterPoint.m_pdfPage->currDy + deltaNoZoom;
			}
		}

		n->m_zoom = newZoom;

		actualZoom = m_win->dm->zoomReal()/100.0; //(newZoom/n->m_zoomAtIns);

		HBITMAP hbmp = NULL;
		long wNote, hNote;

		PAINTSTRUCT ps;
		HDC hdc = BeginPaint(m_win->hwndCanvas, &ps);
		m_Rtf2Bmp->setZoom(m_win->dm->zoomReal()/100.0);
		hbmp = m_Rtf2Bmp->CreateBMP(n->m_strNote, hdc, &wNote, &hNote);
		EndPaint(m_win->hwndCanvas, &ps);

		SizeD dim((double) wNote, (double) hNote);
		ModifyNote(n, n->m_strNote, dim, hbmp);
	}
}

void CPdfNotes::RecalcConnectorsPosition(double newZoom, DisplaySettings *displaySettings, DisplayModel *dm)
{
	for(int i=0;i<m_numConnectors;i++)
	{
		CConnector *ct = GetConnector(i);

		CNote *startNote = ct->m_StartNotaLinked;
		CNote *stopNote = ct->m_StopNotaLinked;

		for(int j=0; j<ct->GetNumLines(); j++)
		{
			CLine *l = ct->GetLine(j);

			double z = newZoom / l->m_zoom;

			if(l->m_P1.m_p.x <0){/*Do nothing*/}
			else
			{
				if(l->m_P1.m_p.x <= l->m_P1.m_pdfPage->currOldDx)
					l->m_P1.m_p.x = (l->m_P1.m_p.x)*z;
				else
				{
					double deltaNoZoom = l->m_P1.m_p.x - l->m_P1.m_pdfPage->currOldDx;
					l->m_P1.m_p.x = l->m_P1.m_pdfPage->currDx + deltaNoZoom;
				}
			}

			//Modify Note Y position
			if(l->m_P1.m_p.y <0){/*Do nothing*/}
			else
			{
				if(l->m_P1.m_p.y < l->m_P1.m_pdfPage->currOldDy)
					l->m_P1.m_p.y = (l->m_P1.m_p.y)*z;
				else
				{
					double deltaNoZoom = l->m_P1.m_p.y - l->m_P1.m_pdfPage->currOldDy;
					l->m_P1.m_p.y = l->m_P1.m_pdfPage->currDy + deltaNoZoom;
				}
			}

			if(l->m_P2.m_p.x <0){/*Do nothing*/}
			else
			{
				if(l->m_P2.m_p.x <= l->m_P2.m_pdfPage->currOldDx)
					l->m_P2.m_p.x = (l->m_P2.m_p.x)*z;
				else
				{
					double deltaNoZoom = l->m_P2.m_p.x - l->m_P2.m_pdfPage->currOldDx;
					l->m_P2.m_p.x = l->m_P2.m_pdfPage->currDx + deltaNoZoom;
				}
			}

			//Modify Note Y position
			if(l->m_P2.m_p.y <0){/*Do nothing*/}
			else
			{
				if(l->m_P2.m_p.y < l->m_P2.m_pdfPage->currOldDy)
					l->m_P2.m_p.y = (l->m_P2.m_p.y)*z;
				else
				{
					double deltaNoZoom = l->m_P2.m_p.y - l->m_P2.m_pdfPage->currOldDy;
					l->m_P2.m_p.y = l->m_P2.m_pdfPage->currDy + deltaNoZoom;
				}
			}

			l->m_zoom = newZoom;
		}
	}

}

void CPdfNotes::MoveNote(CNote *n, WindowInfo *win, int x, int y)
{
	CPageLinkedPoint p = ConvertPointToPageEX(m_win, x, y);

	if(p.m_pdfPage == n->m_CenterPoint.m_pdfPage)
	{
		if(m_deltaX < (int)(-1e9) && m_deltaY<(int)(-1e9))
		{
			m_deltaX = p.m_p.x - n->m_CenterPoint.m_p.x;
			m_deltaY = p.m_p.y - n->m_CenterPoint.m_p.y;
		}
	}
	else
	{
		//To prevent problem in page changing
		m_deltaX = 0;
		m_deltaY = 0;
	}

	n->m_CenterPoint.m_pdfPage = p.m_pdfPage;
	n->m_CenterPoint.m_p.x = p.m_p.x - m_deltaX;
	n->m_CenterPoint.m_p.y = p.m_p.y - m_deltaY;
	n->m_CenterPoint.m_numPage = p.m_numPage;

	//Consider connectors..
	for(int i=0;i<n->GetNumConnectors();i++)
	{
		CConnector *ct = n->GetConnector(i);
		if(ct->m_StartNotaLinked == n)
		{
			CLine *l = ct->GetLine(0);
			l->m_P1 = n->GetPageLinkedCenterPoint();
		}

		if(ct->m_StopNotaLinked == n)
		{
			CLine *l = ct->GetLine(ct->GetNumLines()-1);
			l->m_P2 = n->GetPageLinkedCenterPoint();
		}
	}
}

CConnector* CPdfNotes::AddConnector()
{
	CConnector *ct;

	ct = new CConnector();

	m_connectors = (CConnector **)greallocn(m_connectors, m_numConnectors+1, sizeof(CConnector *));
	m_connectors[m_numConnectors] = ct;
	m_numConnectors++;

	ct->m_lines = NULL;

	return ct;

}

void CPdfNotes::DeleteConnector(int pos)
{
	CConnector *ct = m_connectors[pos];

	//Repositioning elements
	if(pos<m_numConnectors-1)
	{
		for(int i=pos+1; i<m_numConnectors;i++)
		{
			CConnector *CTcurr = m_connectors[i];
			m_connectors[i-1] = CTcurr;
		}

		//Delete last connector
		m_connectors[m_numConnectors-1] = NULL;
	}

	delete ct;
	m_numConnectors--;
}

CConnector* CPdfNotes::GetConnector(int i)
{
	return m_connectors[i];
}

long CPdfNotes::GetNumConnectors()
{
	return m_numConnectors;
}

void CPdfNotes::NewConnector(WindowInfo *win, CPageLinkedPoint pInsert)
{
	CNote *note = NULL;
	CPageLinkedPoint p;
	if(m_posNoteSel>-1)
	{
		note = GetNote(m_posNoteSel);
		p = note->GetPageLinkedCenterPoint();
	}
	else
		p = pInsert;

	CConnector *ct = AddConnector();
	ct->m_TipoIndicatore = _INDICATORE_NO_;
	ct->m_StartNotaLinked = note;

	ct->AddLine(p, p, win->dm->zoomReal());

	//add reference to connector
	if(m_posNoteSel>-1)
		note->AddConnector(ct);

	ct->m_Color = m_ConnectorColor;

	m_curConnector = GetNumConnectors()-1;
	m_curConnectorLine = ct->GetNumLines()-1;
}

void CPdfNotes::SavePNS(char *pathFile, WindowInfo *win)
{
	char *data = NULL;

	CString tmpStr;
	long pos = 0;
	tmpStr.Format("%s\n", _PDFNOTES_I_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _INFO_I_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _PDFNOTESVERSION_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _INFO_F_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _PDF_I_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _PDF_FILE_NAME_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", win->dm->fileName());
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _PDF_TOTPAGE_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%d\n", win->dm->pageCount());
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _PDF_ZOOM_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%f\n", win->dm->zoomReal());
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _PDF_XORIGIN_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%d\n", m_xOrigin);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _PDF_F_);
	data = WriteString(data, tmpStr, &pos);

	//General settings
	tmpStr.Format("%s\n", _SETTINGS_I_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _SETTINGS_NOTE_FONT_COLOR_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%d\n", m_fontColor);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _SETTINGS_NOTE_FONT_FACE_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", m_lfNote.lfFaceName);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _SETTINGS_NOTE_FONT_HEIGHT_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%d\n", m_lfNote.lfHeight);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _SETTINGS_NOTE_FONT_ITALIC_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%d\n", m_lfNote.lfItalic);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _SETTINGS_NOTE_FONT_BOLD_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%d\n", m_lfNote.lfWeight);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _SETTINGS_ULINE_COLOR_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%d\n", m_ULineColor);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _SETTINGS_CONNECTOR_COLOR_);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%d\n", m_ConnectorColor);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%s\n", _SETTINGS_F_);
	data = WriteString(data, tmpStr, &pos);

	//notes
	tmpStr.Format("%s\n", _NOTES_I_);
	data = WriteString(data, tmpStr, &pos);

	for(int i=0; i<m_numNotes; i++)
	{
		CNote *n = GetNote(i);

		tmpStr.Format("%s\n", _NOTE_I_);
		data = WriteString(data, tmpStr, &pos);

		//Geometry
		tmpStr.Format("%s\n", _NOTE_CENTER_X_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%f\n", n->m_CenterPoint.m_p.x );
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_CENTER_Y_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%f\n", n->m_CenterPoint.m_p.y );
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_CENTER_NUMPAGE_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", n->m_CenterPoint.m_numPage);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_WIDTH_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%f\n", n->m_wNote );
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_HEIGHT_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%f\n", n->m_hNote);
		data = WriteString(data, tmpStr, &pos);

		//RTF
		tmpStr.Format("%s\n", _NOTE_RTF_I_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", n->m_strNote);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_RTF_F_);
		data = WriteString(data, tmpStr, &pos);

		//Connectors linked
		tmpStr.Format("%s\n", _NOTE_CONNECTOR_I_);
		data = WriteString(data, tmpStr, &pos);

		for(int j=0; j<n->m_numConnectors; j++)
		{
			CConnector *ct = n->GetConnector(j);
			int posSt = GetPosConnector(ct);
			tmpStr.Format("%d\n", posSt );
			data = WriteString(data, tmpStr, &pos);
		}

		tmpStr.Format("%s\n", _NOTE_CONNECTOR_F_);
		data = WriteString(data, tmpStr, &pos);

		//Font and color Information...
		tmpStr.Format("%s\n", _NOTE_FONT_COLOR_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", n->m_fontColor);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_FONT_FACE_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", n->m_lfNote.lfFaceName);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_FONT_HEIGHT_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", n->m_lfNote.lfHeight);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_FONT_ITALIC_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", n->m_lfNote.lfItalic);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_FONT_BOLD_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", n->m_lfNote.lfWeight);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _NOTE_F_);
		data = WriteString(data, tmpStr, &pos);
	}

	tmpStr.Format("%s\n", _NOTES_F_);
	data = WriteString(data, tmpStr, &pos);

	//Connectors...
	tmpStr.Format("%s\n", _CONNECTORS_I_);
	data = WriteString(data, tmpStr, &pos);

	for(int i=0;i<m_numConnectors; i++)
	{
		CConnector *ct = GetConnector(i);

		tmpStr.Format("%s\n", _CONNECTOR_I_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _CONNECTOR_TIPO_INDICATORE_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", ct->m_TipoIndicatore);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _CONNECTOR_POS_INDICATORE_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", ct->m_PosIndicatore);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _CONNECTOR_COLOR_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", ct->m_Color);
		data = WriteString(data, tmpStr, &pos);

		//Linked Notes... (start and stop)
		tmpStr.Format("%s\n", _CONNECTOR_NOTE_LINKED_I_);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", GetPosNote(ct->m_StartNotaLinked));
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%d\n", GetPosNote(ct->m_StopNotaLinked));
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _CONNECTOR_NOTE_LINKED_F_);
		data = WriteString(data, tmpStr, &pos);

		//Lines belonging to connector
		tmpStr.Format("%s\n", _CONNECTOR_LINES_I);
		data = WriteString(data, tmpStr, &pos);

		for(int j=0; j<ct->m_numLines; j++)
		{
			CLine *l = ct->GetLine(j);

			tmpStr.Format("%s\n", _CONNECTOR_LINE_I);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", l->m_P1.m_p.x);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", l->m_P1.m_p.y);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%d\n", l->m_P1.m_numPage);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", l->m_P2.m_p.x);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", l->m_P2.m_p.y);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%d\n", l->m_P2.m_numPage);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _CONNECTOR_LINE_F);
			data = WriteString(data, tmpStr, &pos);
		}

		tmpStr.Format("%s\n", _CONNECTOR_LINES_F);
		data = WriteString(data, tmpStr, &pos);

		tmpStr.Format("%s\n", _CONNECTOR_F_);
		data = WriteString(data, tmpStr, &pos);
	}

	tmpStr.Format("%s\n", _CONNECTOR_F_);
	data = WriteString(data, tmpStr, &pos);

	//-->ULines
	tmpStr.Format("%s\n", _ULINES_I_);
	data = WriteString(data, tmpStr, &pos);

	for(int i=0; i<win->dm->pageCount(); i++)
	{
		PdfPageInfo *pInfo = win->dm->getPageInfo(i+1);
		for(int k=0; k<pInfo->pnElements->m_numLines; k++)
		{
			CULine *l = pInfo->pnElements->GetULine(k);

			tmpStr.Format("%s\n", _ULINE_I_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _ULINE_PAGE_I_);
			data = WriteString(data, tmpStr, &pos);
			
			tmpStr.Format("%d\n", i+1);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _ULINE_PAGE_F_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _ULINE_POINTS_I_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", l->m_p1.x);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", l->m_p1.y);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", l->m_p2.x);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", l->m_p2.y);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _ULINE_POINTS_F_);
			data = WriteString(data, tmpStr, &pos);

			//Color used
			tmpStr.Format("%s\n", _ULINE_COLOR_I_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%d\n", l->m_Color);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _ULINE_COLOR_F_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _ULINE_F_);
			data = WriteString(data, tmpStr, &pos);
		}
	}

	tmpStr.Format("%s\n", _ULINES_F_);
	data = WriteString(data, tmpStr, &pos);

	//HLight
	tmpStr.Format("%s\n", _HLIGHTS_I_);
	data = WriteString(data, tmpStr, &pos);

	//Insert default Height used
	tmpStr.Format("%s\n", _HLIGHT_HEIGHT);
	data = WriteString(data, tmpStr, &pos);

	tmpStr.Format("%d\n", m_curHeightPt);
	data = WriteString(data, tmpStr, &pos);

	for(int i=0; i<win->dm->pageCount(); i++)
	{
		PdfPageInfo *pInfo = win->dm->getPageInfo(i+1);
		for(int k=0; k<pInfo->pnElements->m_numHLight; k++)
		{
			CHighLight *hL = pInfo->pnElements->GetHighLight(k);

			tmpStr.Format("%s\n", _HLIGHT_I_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _HLIGHT_PAGE_I_);
			data = WriteString(data, tmpStr, &pos);
			
			tmpStr.Format("%d\n", i+1);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _HLIGHT_PAGE_F_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _HLIGHT_HEIGHT_I_);
			data = WriteString(data, tmpStr, &pos);
			
			tmpStr.Format("%d\n", hL->m_height);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _HLIGHT_HEIGHT_F_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _HLIGHT_POINTS_I_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", hL->m_p1.x);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", hL->m_p1.y);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", hL->m_p2.x);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%f\n", hL->m_p2.y);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _HLIGHT_POINTS_F_);
			data = WriteString(data, tmpStr, &pos);

			tmpStr.Format("%s\n", _HLIGHT_F_);
			data = WriteString(data, tmpStr, &pos);
		}
	}
	tmpStr.Format("%s\n", _HLIGHTS_F_);
	data = WriteString(data, tmpStr, &pos);

	//Final Tag
	tmpStr.Format("%s\n", _PDFNOTES_F_);
	data = WriteString(data, tmpStr, &pos);

	long size = _msize(data);
	write_to_file(pathFile, (void*)data, size);
}

char * CPdfNotes::WriteString(char *data, CString str, long *InsPos)
{
	int sString = str.GetLength();
	if(data == NULL)
		data = (char*)malloc(sString * sizeof(char));
	else
	{
		long size = _msize(data);
		data = (char*)realloc(data, size + sString*sizeof(char));
	}

	for(int i=0; i<sString; i++)
	{
		data[*InsPos] = str.GetAt(i);
		*InsPos = *InsPos +1;
	}

	return data;
}

int CPdfNotes::GetPosConnector(CConnector *ct)
{
	int pos = -1;

	for(int i=0; i<m_numConnectors; i++)
	{
		CConnector *ct1 = GetConnector(i);
		if(ct == ct1)
		{
			pos = i;
			break;
		}
	}

	return pos;
}

int CPdfNotes::GetPosNote(CNote *n)
{
	int pos = -1;

	for(int i=0; i<m_numNotes; i++)
	{
		CNote *n1 = GetNote(i);
		if(n == n1)
		{
			pos = i;
			break;
		}
	}

	return pos;
}

void CPdfNotes::FreeResurces(WindowInfo *win)
{
	//Free Notes
	int n = m_numNotes;
	for(int i=0;i<n; i++)
	{
		DeleteNote(0);
	}
	m_numNotes = 0;
	free(m_notes);
	m_notes = NULL;

	//Free Connectors...
	n = m_numConnectors;
	for(int i=0;i<n;i++)
	{
		DeleteConnector(0);
	}
	m_numConnectors = 0;
	free(m_connectors);
	m_connectors = NULL;

	//Now free ULines e HLight
	for(int i=1;i<win->dm->pageCount(); i++)
	{
		if(win->dm->getPageInfo(i)->pnElements->HasElements() == true)
		{
			n = win->dm->getPageInfo(i)->pnElements->m_numLines;
			if(n>0)
			{
				for(int k=0; k<n;k++)
				{
					win->dm->getPageInfo(i)->pnElements->DeleteULine(0);
				}

				free(win->dm->getPageInfo(i)->pnElements->m_uLines);
				win->dm->getPageInfo(i)->pnElements->m_numLines =0;
				win->dm->getPageInfo(i)->pnElements->m_uLines = NULL;
			}

			n = win->dm->getPageInfo(i)->pnElements->m_numHLight;
			if(n>0)
			{
				for(int k=0; k<n;k++)
				{
					win->dm->getPageInfo(i)->pnElements->DeleteHighLight(0);
				}

				free(win->dm->getPageInfo(i)->pnElements->m_hLight);
				win->dm->getPageInfo(i)->pnElements->m_numHLight =0;
				win->dm->getPageInfo(i)->pnElements->m_hLight = NULL;
			}
		}
	}

}

void CPdfNotes::OpenPNS(char *pathFile, WindowInfo *win)
{
	char *data = NULL;
	uint64_t FileLen;
	float zoomUsed= 0.0;

	data = file_read_all(pathFile, &FileLen);

	//Free Resurces if needed
	FreeResurces(win);

	long curPos =0;
	CString strTemp;
	bool bEsc = false;
	while(bEsc == false)
	{
		if(curPos >= FileLen)
			bEsc = true;
		else
		{
			strTemp = ReadString(data, &curPos, (long)FileLen);

			if(strTemp == _PDF_FILE_NAME_)
			{
				//Read Pdf File name
				strTemp = ReadString(data, &curPos, (long)FileLen);

				//Is the same pdf file opened?
				if(IsSameFile(strTemp, win->dm->fileName()) == false)
					bEsc = true;
			}
			else if(strTemp == _PDF_TOTPAGE_)
			{
				//Read Pdf Num of Pages
				strTemp = ReadString(data, &curPos, (long)FileLen);
				if(atoi(strTemp) != win->dm->pageCount())
					bEsc = true;
			}
			else if(strTemp == _PDF_ZOOM_)
			{
				//Read Pdf Zoom when notes are saved
				strTemp = ReadString(data, &curPos, (long)FileLen);
				zoomUsed = atof(strTemp);
			}
			else if(strTemp == _PDF_XORIGIN_)
			{
				//Read Pdf X Origin
				strTemp = ReadString(data, &curPos, (long)FileLen);
				m_xOrigin = atoi(strTemp);

				//Set Display Settings
				DisplaySettings *displaySettings = globalDisplaySettings();
				if(m_xOrigin != displaySettings->paddingPageBorderLeft)
				{
					displaySettings->paddingPageBorderLeft = m_xOrigin;
					displaySettings->paddingPageBorderRight = m_xOrigin;
				}

				//Set DisplayModel
				win->dm->changeDisplayMode(DM_CONTINUOUS);

				//-->NOTE
				//-->Set zoom before inserting objects in PdfNotes
				win->dm->zoomTo(zoomUsed);
			}
			else if(strTemp == _SETTINGS_NOTE_FONT_COLOR_)
			{
				//read default Note font color
				strTemp = ReadString(data, &curPos, (long)FileLen);
				m_fontColor = atoi(strTemp);		
			}
			else if(strTemp == _SETTINGS_NOTE_FONT_FACE_)
			{
				//read default Note font color
				strTemp = ReadString(data, &curPos, (long)FileLen);
				_tcscpy(m_lfNote.lfFaceName, strTemp);
			}
			else if(strTemp == _SETTINGS_NOTE_FONT_HEIGHT_)
			{
				//read default Note font color
				strTemp = ReadString(data, &curPos, (long)FileLen);
				m_lfNote.lfHeight = atoi(strTemp);
			}
			else if(strTemp == _SETTINGS_NOTE_FONT_ITALIC_)
			{
				//read default Note font color
				strTemp = ReadString(data, &curPos, (long)FileLen);
				m_lfNote.lfItalic = atoi(strTemp);
			}
			else if(strTemp == _SETTINGS_NOTE_FONT_BOLD_)
			{
				//read default Note font color
				strTemp = ReadString(data, &curPos, (long)FileLen);
				m_lfNote.lfWeight = atoi(strTemp);
			}
			else if(strTemp == _SETTINGS_ULINE_COLOR_)
			{
				//read default Note font color
				strTemp = ReadString(data, &curPos, (long)FileLen);
				m_ULineColor = atoi(strTemp);
			}
			else if(strTemp == _SETTINGS_CONNECTOR_COLOR_)
			{
				//read default Note font color
				strTemp = ReadString(data, &curPos, (long)FileLen);
				m_ConnectorColor = atoi(strTemp);
			}
			else if(strTemp == _NOTE_I_)
			{
				//Load a Note...
				bool bEscNote = false;
				bool bInsertNote = false;
				RectD rNote;
				CString strNote;
				CNote *note = NULL;
				CPageLinkedPoint pL;
				SizeD dimension;
				while(bEscNote == false)
				{
					strTemp = ReadString(data, &curPos, (long)FileLen);
					if(strTemp == _NOTE_F_ || curPos >= FileLen)
					{
						bEscNote = true;
					}
					else
					{
						if(strTemp == _NOTE_CENTER_X_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							pL.m_p.x = (double)atof(strTemp);
						}
						else if(strTemp == _NOTE_CENTER_Y_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							pL.m_p.y = (double)atof(strTemp);
						}
						else if(strTemp == _NOTE_CENTER_NUMPAGE_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							pL.m_numPage = atoi(strTemp);
							pL.m_pdfPage = win->dm->getPageInfo(atoi(strTemp));
						}
						else if(strTemp == _NOTE_WIDTH_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							dimension.setDx((double)atof(strTemp));
						}
						else if(strTemp == _NOTE_HEIGHT_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							dimension.setDy((double)atof(strTemp));
						}
						else if(strTemp == _NOTE_RTF_I_)
						{
							strNote = "";
							bool bEscRtf = false;
							while(bEscRtf == false)
							{
								strTemp = ReadString(data, &curPos, (long)FileLen);
								if(strTemp == _NOTE_RTF_F_)
									bEscRtf = true;
								else
								{
									strNote = strNote + strTemp;
								}
							}
						}
						else if(strTemp == _NOTE_CONNECTOR_I_)
						{
							note = AddNote(pL, dimension, strNote, NULL, zoomUsed);

							//Insert link to connectors...
							bool bEscStrokes = false;
							while(bEscStrokes == false)
							{
								strTemp = ReadString(data, &curPos, (long)FileLen);
								if(strTemp == _NOTE_CONNECTOR_F_)
									bEscStrokes = true;
								else
								{
									long n = atol(strTemp);
									note->AddLoadedConnector(n);
								}
							}
						}
						else if(strTemp == _NOTE_FONT_COLOR_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							note->m_fontColor = atoi(strTemp);
						}
						else if(strTemp == _NOTE_FONT_FACE_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							_tcscpy(note->m_lfNote.lfFaceName, strTemp);
						}
						else if(strTemp == _NOTE_FONT_HEIGHT_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							note->m_lfNote.lfHeight = atoi(strTemp);
						}
						else if(strTemp == _NOTE_FONT_ITALIC_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							note->m_lfNote.lfItalic = atoi(strTemp);
						}
						else if(strTemp == _NOTE_FONT_BOLD_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							note->m_lfNote.lfWeight = atoi(strTemp);
						}
					}
				}
			}
			else if(strTemp == _CONNECTOR_I_)
			{
				//Insert a connector
				CConnector *ct = AddConnector();

				bool bEscStroke = false;
				while(bEscStroke == false)
				{
					strTemp = ReadString(data, &curPos, (long)FileLen);
					if(strTemp == _CONNECTOR_F_)
						bEscStroke = true;
					else
					{
						if(strTemp == _CONNECTOR_TIPO_INDICATORE_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							ct->m_TipoIndicatore = atoi(strTemp);
						}
						else if(strTemp == _CONNECTOR_POS_INDICATORE_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							ct->m_PosIndicatore = atoi(strTemp);
						}
						else if(strTemp == _CONNECTOR_COLOR_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							ct->m_Color = atoi(strTemp);
						}
						else if(strTemp == _CONNECTOR_NOTE_LINKED_I_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							ct->m_StartNotaLinked = GetNote(atoi(strTemp));

							strTemp = ReadString(data, &curPos, (long)FileLen);
							ct->m_StopNotaLinked = GetNote(atoi(strTemp));
						}
						else if(strTemp == _CONNECTOR_LINE_I)
						{
							CPageLinkedPoint p1, p2;
							
							strTemp = ReadString(data, &curPos, (long)FileLen);
							p1.m_p.x = (double) atof(strTemp);

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p1.m_p.y = (double) atof(strTemp);

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p1.m_numPage = atoi(strTemp);

							p1.m_pdfPage = win->dm->getPageInfo(atoi(strTemp));

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p2.m_p.x = (double) atof(strTemp);

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p2.m_p.y = (double) atof(strTemp);

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p2.m_numPage = atoi(strTemp);

							p2.m_pdfPage = win->dm->getPageInfo(atoi(strTemp));

							ct->AddLine(p1,p2, zoomUsed);
						}
					}
				}

				//Verify that connector has lines...
				if(ct->GetNumLines() == 0)
				{
					//Delete last connector inserted
					DeleteConnector(GetNumConnectors()-1);
				}

			}
			else if(strTemp == _ULINE_I_)
			{
				//Insert a ULine
				PdfPageInfo *pInfo = NULL;
				PointD p1, p2;
				bool bEscUline = false;
				CULine *ul = NULL;
				while(bEscUline == false)
				{
					strTemp = ReadString(data, &curPos, (long)FileLen);
					if(strTemp == _ULINE_F_)
						bEscUline = true;
					else
					{
						if(strTemp == _ULINE_PAGE_I_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							pInfo = win->dm->getPageInfo(atoi(strTemp));
						}
						else if(strTemp == _ULINE_POINTS_I_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							p1.x = (double)(atof(strTemp));

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p1.y = (double)(atof(strTemp));

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p2.x = (double)(atof(strTemp));

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p2.y = (double)(atof(strTemp));

							ul = pInfo->pnElements->AddULine(p1, p2, zoomUsed);
						}
						else if(strTemp == _ULINE_COLOR_I_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							ul->m_Color = atoi(strTemp);
						}
					}
				}
			}
			else if(strTemp == _HLIGHT_HEIGHT)
			{
				strTemp = ReadString(data, &curPos, (long)FileLen);
				m_curHeightPt = atoi(strTemp);
			}
			else if(strTemp == _HLIGHT_I_)
			{
				//Insert a ULine
				PdfPageInfo *pInfo = NULL;
				PointD p1, p2;
				int h = -1;
				bool bEscHLight = false;
				while(bEscHLight == false)
				{
					strTemp = ReadString(data, &curPos, (long)FileLen);
					if(strTemp == _HLIGHT_F_)
						bEscHLight = true;
					else
					{
						if(strTemp == _HLIGHT_PAGE_I_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							pInfo = win->dm->getPageInfo(atoi(strTemp));
						}
						else if(strTemp == _HLIGHT_HEIGHT_I_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							h = atoi(strTemp);
						}
						else if(strTemp == _HLIGHT_POINTS_I_)
						{
							strTemp = ReadString(data, &curPos, (long)FileLen);
							p1.x = (double)(atof(strTemp));

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p1.y = (double)(atof(strTemp));

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p2.x = (double)(atof(strTemp));

							strTemp = ReadString(data, &curPos, (long)FileLen);
							p2.y = (double)(atof(strTemp));

							pInfo->pnElements->AddHighLight(p1, p2, h, zoomUsed);
						}
					}
				}
			}
		}
	}

	//Create bitmap of rtf and link correctly the connectors
	for(int i=0; i<m_numNotes; i++)
	{
		CNote *n = GetNote(i);
		for(int k=0; k<n->m_numConnectorsLoaded; k++)
		{
			long num = (n->m_pLoadedConnectors[k]);
			CConnector *ct = GetConnector((int)(num));
			n->AddConnector(ct);
		}
		
		n->m_pLoadedConnectors = NULL;
		free(n->m_pLoadedConnectors);
		n->m_numConnectorsLoaded = 0;

		//Render RTF
		HBITMAP hbmp = NULL;
		long wNote, hNote;

		PAINTSTRUCT ps;
		HDC hdc = BeginPaint(m_win->hwndCanvas, &ps);
		m_Rtf2Bmp->setZoom(m_win->dm->zoomReal()/100.0);
		hbmp = m_Rtf2Bmp->CreateBMP(n->m_strNote, hdc, &wNote, &hNote);
		EndPaint(m_win->hwndCanvas, &ps);

		SizeD dim((double) wNote, (double) hNote);
		ModifyNote(n, n->m_strNote, dim, hbmp);

	}

	HCURSOR CursorArrow = LoadCursor(NULL, IDC_ARROW);
	SetCursor(CursorArrow);

}

CString CPdfNotes::ReadString(char *data, long *curPos, long FileLen)
{
	CString retStr = "";

	long startPos = *curPos;
	if(data[startPos] == '\n')
	{
		startPos ++;
		*curPos = *curPos +1;
	}

	bool bEsc = false;
	while(bEsc == false)
	{
		if(*curPos >= FileLen)
			bEsc = true;
		else
		{
			if(data[startPos] == '\n')
				bEsc = true;
			else
				retStr = retStr + data[startPos];
		}

		startPos ++;
		*curPos = *curPos +1;
	}

	return retStr;
}

bool CPdfNotes::IsSameFile(CString pathFromPNS, const char *pathLoaded)
{
	return true;
}

//---------------------------------------CULine-----------------------------------------------
//--------------------------------------------------------------------------------------------
CULine::CULine(void)
{
	m_bIsSelected = false;
}

CULine::~CULine(void)
{

}

//---------------------------------------CHighLight-----------------------------------------------
//--------------------------------------------------------------------------------------------
CHighLight::CHighLight(void)
{
	m_bIsSelected = false;
}

CHighLight::~CHighLight(void)
{

}

RECT CHighLight::GetRect()
{
	RECT rect;

	if(m_p2.x > m_p1.x)
	{
		rect.left = m_p1.x;
		rect.top = m_p1.y - long(m_height/2.0 * (m_Zoom/100.0)  + 0.5);
		rect.right = m_p1.x + (m_p2.x - m_p1.x);
		rect.bottom = m_p1.y + long(m_height/2.0 * (m_Zoom/100.0) + 0.5);
	}
	else
	{
		rect.left = m_p2.x;
		rect.top = m_p2.y - long(m_height / 2.0 * (m_Zoom/100.0) + 0.5);
		rect.right = m_p2.x + (m_p1.x - m_p2.x);
		rect.bottom = m_p2.y + long(m_height/2.0 * (m_Zoom/100.0) + 0.5);
	}

	return rect;
}

//---------------------------------------CPdfNotesElements------------------------------------
//--------------------------------------------------------------------------------------------
CPdfNotesElements::CPdfNotesElements(void)
{
	m_numLines = 0;
	m_uLines = NULL;

	m_numHLight = 0;
	m_hLight = NULL;
}

CPdfNotesElements::~CPdfNotesElements(void)
{
}

CULine* CPdfNotesElements::AddULine(PointD p1, PointD p2, double zoom)
{
	//Add Underline
	CULine *uL;

	uL = new CULine();
	uL->m_p1.x = p1.x;
	uL->m_p1.y = p1.y;

	uL->m_p2.x = p2.x;
	uL->m_p2.y = p2.y;
	uL->m_Zoom = zoom;

	m_uLines = (CULine **)greallocn(m_uLines, m_numLines+1, sizeof(CULine *));
	m_uLines[m_numLines] = uL;
	m_numLines++;

	return uL;
}

void CPdfNotesElements::DeleteULine(int pos)
{
	CULine *uL = m_uLines[pos];

	//repositioning
	if(pos<m_numLines-1)
	{
		for(int i=pos+1; i<m_numLines;i++)
		{
			CULine *uLcurr = m_uLines[i];
			m_uLines[i-1] = uLcurr;
		}

		//Delete last line
		m_uLines[m_numLines-1] = NULL;
	}

	delete uL;
	m_numLines--;
}

CULine* CPdfNotesElements::GetULine(int i)
{
	return m_uLines[i];
}

long CPdfNotesElements::GetNumULines()
{
	return m_numLines;
}

CHighLight* CPdfNotesElements::AddHighLight(PointD p1, PointD p2, int height, double zoom)
{
	//Add a HighLight
	CHighLight *hL;

	hL = new CHighLight();
	hL->m_p1.x = p1.x;
	hL->m_p1.y = p1.y;

	hL->m_p2.x = p2.x;
	hL->m_p2.y = p2.y;
	hL->m_Zoom = zoom;
	hL->m_height = height;

	m_hLight = (CHighLight **)greallocn(m_hLight, m_numHLight+1, sizeof(CHighLight *));
	m_hLight[m_numHLight] = hL;
	m_numHLight++;

	return hL;
}

void CPdfNotesElements::DeleteHighLight(int pos)
{
	CHighLight *hL = m_hLight[pos];

	//Repositioning
	if(pos<m_numHLight-1)
	{
		for(int i=pos+1; i<m_numHLight;i++)
		{
			CHighLight *hLcurr = m_hLight[i];
			m_hLight[i-1] = hLcurr;
		}

		//Delete last line
		m_hLight[m_numHLight-1] = NULL;
	}

	delete hL;
	m_numHLight--;
}

CHighLight* CPdfNotesElements::GetHighLight(int i)
{
	return m_hLight[i];
}

long CPdfNotesElements::GetNumHighLight()
{
	return m_numHLight;
}

bool CPdfNotesElements::HasElements()
{
	if(m_numLines>0 || m_numHLight>0)
		return true;
	else
		return false;
}

void CPdfNotesElements::DrawElements(WindowInfo *win, HDC hdc, POINT pDest, POINT pSrc)
{
	//Draw UnderLines
	for(int i=0; i<m_numLines; i++)
	{
		CULine *uL = m_uLines[i];

		int xPos, yPos;
		
		if(pSrc.x>0)
			xPos = uL->m_p1.x - pSrc.x;
		else
			xPos = pDest.x + uL->m_p1.x;

		if(pSrc.y>0)
			yPos = uL->m_p1.y - pSrc.y;
		else
			yPos = pDest.y + uL->m_p1.y;

		MoveToEx(hdc, xPos, yPos, NULL);

		if(pSrc.x>0)
			xPos = uL->m_p2.x - pSrc.x;
		else
			xPos = pDest.x + uL->m_p2.x;

		if(pSrc.y>0)
			yPos = uL->m_p2.y - pSrc.y;
		else
			yPos = pDest.y + uL->m_p2.y;
		
		HPEN penUsed;
		HGDIOBJ prevPen;
		LOGPEN  pen;
		if(uL->m_bIsSelected == true)
		{
			pen.lopnStyle = PS_SOLID;
			pen.lopnWidth.x = 1;
			pen.lopnWidth.y = 1;
			pen.lopnColor = _ULINE_SEL_COLOR_;
			penUsed = CreatePenIndirect(&pen);
		}
		else
		{
			pen.lopnStyle = PS_SOLID;
			pen.lopnWidth.x = 1;
			pen.lopnWidth.y = 1;
			pen.lopnColor = uL->m_Color; //_ULINE_COLOR_;
			penUsed = CreatePenIndirect(&pen);
		}

		prevPen = SelectObject(hdc, penUsed);

		LineTo(hdc, xPos, yPos);

		SelectObject(hdc, prevPen);
		DeleteObject(penUsed);
	}

	//Draw HighLight
	for(int i=0; i<m_numHLight; i++)
	{
		CHighLight *hL = GetHighLight(i);

		int xP1, yP1, xP2, yP2;
		
		if(pSrc.x>0)
			xP1 = hL->m_p1.x - pSrc.x;
		else
			xP1 = pDest.x + hL->m_p1.x;

		if(pSrc.y>0)
			yP1 = hL->m_p1.y - pSrc.y;
		else
			yP1 = pDest.y + hL->m_p1.y;


		if(pSrc.x>0)
			xP2 = hL->m_p2.x - pSrc.x;
		else
			xP2 = pDest.x + hL->m_p2.x;

		if(pSrc.y>0)
			yP2 = hL->m_p2.y - pSrc.y;
		else
			yP2 = pDest.y + hL->m_p2.y;

		RECT rect;
		if(xP2 > xP1)
		{
			rect.left = xP1;
			rect.top = yP1 - long(hL->m_height/2.0 * (hL->m_Zoom/100.0) + 0.5);
			rect.right = xP1 + (xP2 - xP1);
			rect.bottom = yP1 + long(hL->m_height/2.0 * (hL->m_Zoom/100.0) + 0.5);
		}
		else
		{
			rect.left = xP2;
			rect.top = yP1 - long(hL->m_height / 2.0 * (hL->m_Zoom/100.0) + 0.5);
			rect.right = xP2 + (xP1 - xP2);
			rect.bottom = yP1 + long(hL->m_height/2.0 * (hL->m_Zoom/100.0) + 0.5);
		}

		//draw it...
		PaintTransparentRectangle(win, hdc, &rect, hL->m_bIsSelected, false);
	}
}
void CPdfNotesElements::RecalcElementsPosition(double newZoom)
{
	//Recalc Lines Position
	for(int i=0; i<m_numLines;i++)
	{
		CULine *uL = m_uLines[i];

		double z = newZoom / uL->m_Zoom;

		uL->m_p1.x = uL->m_p1.x * z;
		uL->m_p1.y = uL->m_p1.y * z;

		uL->m_p2.x = uL->m_p2.x * z;
		uL->m_p2.y = uL->m_p2.y * z;

		uL->m_Zoom = newZoom;
	}

	//Recalc HighLight Position
	for(int i=0; i<m_numHLight;i++)
	{
		CHighLight *hL = m_hLight[i];

		double z = newZoom / hL->m_Zoom;

		hL->m_p1.x = hL->m_p1.x * z;
		hL->m_p1.y = hL->m_p1.y * z;

		hL->m_p2.x = hL->m_p2.x * z;
		hL->m_p2.y = hL->m_p2.y * z;

		hL->m_Zoom = newZoom;
	}
}


//----------------------------------------------CNote------------------------------------
//--------------------------------------------------------------------------------------------
CNote::CNote(void)
{
	m_strNote = _T("");
	m_numConnectors = 0;
	m_numConnectorsLoaded = 0;

	m_pLoadedConnectors = NULL;

}

CNote::~CNote(void)
{
}

POINT CNote::CenterPoint()
{
	POINT p;
	p.x = m_CenterPoint.m_pdfPage->currPosX + m_CenterPoint.m_p.x;
	p.y = m_CenterPoint.m_pdfPage->currPosY + + m_CenterPoint.m_p.y;

	return p;
}

CPageLinkedPoint CNote::GetPageLinkedCenterPoint()
{
	return m_CenterPoint;
}

void CNote::FindNotePoints(PointD *p1, PointD *p2, PointD *p3, PointD *p4)
{
	//Find Rectangle Points
	POINT p = TopLeft();
	p1->set(p.x, p.y);

	p = BottomRight();
	p3->set(p.x, p.y);

	*p2 = *p1;
	p2->x = p2->x + Width();

	*p4 = *p3;
	p4->x = p4->x - Width();
}

void CNote::FindNotePoints(CPageLinkedPoint *p1, CPageLinkedPoint *p2, CPageLinkedPoint *p3, CPageLinkedPoint *p4)
{
	p1->Set(&m_CenterPoint);
	p2->Set(&m_CenterPoint);
	p3->Set(&m_CenterPoint);
	p4->Set(&m_CenterPoint);

	//Top-Left
	p1->m_p.x = p1->m_p.x - m_wNote /2.0;
	p1->m_p.y = p1->m_p.y - m_hNote /2.0;

	//Top-Right
	p2->m_p.x = p2->m_p.x + m_wNote /2.0;
	p2->m_p.y = p2->m_p.y - m_hNote /2.0;

	//Bottom-Right
	p3->m_p.x = p3->m_p.x + m_wNote /2.0;
	p3->m_p.y = p3->m_p.y + m_hNote /2.0;

	//Bottom-Left
	p4->m_p.x = p4->m_p.x - m_wNote /2.0;
	p4->m_p.y = p4->m_p.y + m_hNote /2.0;
}

void CNote::FindNotePoints(POINT *p1, POINT *p2, POINT *p3, POINT *p4)
{
	//Find Rectangle Points
	*p1 = TopLeft();
	*p3 = BottomRight();
	*p2 = *p1;
	p2->x = p2->x + Width();
	*p4 = *p3;
	p4->x = p4->x - Width();
}

double CNote::Width()
{
	return m_wNote; //(m_rNote.right - m_rNote.left);
}

double CNote::Height()
{
	return m_hNote; //(m_rNote.bottom - m_rNote.top);
}


POINT CNote::TopLeft()
{
	POINT p;
	p.x = m_CenterPoint.m_p.x - m_wNote/2; //m_rNote.left;
	p.y = m_CenterPoint.m_p.y - m_hNote/2; //m_rNote.top;

	return p;
}

POINT CNote::BottomRight()
{
	POINT p;
	p.x = m_CenterPoint.m_p.x + m_wNote/2; //m_rNote.right;
	p.y = m_CenterPoint.m_p.y + m_hNote/2; //m_rNote.bottom;

	return p;
}

void CNote::AddConnector(CConnector *ct)
{
	m_connectors = (CConnector **)greallocn(m_connectors, m_numConnectors+1, sizeof(CConnector *));
	m_connectors[m_numConnectors] = ct;
	m_numConnectors++;
}

void CNote::DeleteConnector(int pos)
{
	//Repositiong array elements
	if(pos<m_numConnectors-1)
	{
		for(int i=pos+1; i<m_numConnectors;i++)
		{
			CConnector *CTcurr = m_connectors[i];
			m_connectors[i-1] = CTcurr;
		}

		//Delete last connector
		m_connectors[m_numConnectors-1] = NULL;
	}

	m_numConnectors--;
}

CConnector* CNote::GetConnector(int i)
{
	return m_connectors[i];
}

long CNote::GetNumConnectors()
{
	return m_numConnectors;
}

void CNote::AddLoadedConnector(long ConnectorPos)
{
	if(m_pLoadedConnectors == NULL)
		m_pLoadedConnectors = (long *)malloc(sizeof(long));
	else
	{
		long size = _msize(m_pLoadedConnectors);
		m_pLoadedConnectors = (long *)realloc(m_pLoadedConnectors, size + sizeof(long));
	}

	m_pLoadedConnectors[m_numConnectorsLoaded] = ConnectorPos;
	m_numConnectorsLoaded++;
}

//----------------------------------------CLine------------------------------------
//---------------------------------------------------------------------------------
CLine::CLine(void)
{
	m_bIsSelected = false;
}

CLine::~CLine(void)
{
}

//----------------------------------------CConnector----------------------------------
//---------------------------------------------------------------------------------
CConnector::CConnector(void)
{
	m_TipoIndicatore = _INDICATORE_FRECCIA_;
	m_PosIndicatore = _POS_INDICATORE_FINE_TRATTO;

	m_StartNotaLinked = NULL;
	m_StopNotaLinked = NULL;

	m_IsSelected = false;

	m_numLines = 0;
}

CConnector::~CConnector(void)
{
}

CLine* CConnector::AddLine(CPageLinkedPoint p1, CPageLinkedPoint p2, double zoom)
{
	//Add a line
	CLine *l;

	l = new CLine();
	l->m_P1.Set(&p1);
	l->m_P2.Set(&p2);
	l->m_zoom = zoom;

	m_lines = (CLine **)greallocn(m_lines, m_numLines+1, sizeof(CLine *));
	m_lines[m_numLines] = l;
	m_numLines++;

	return l;
}
void CConnector::DeleteLine(int pos)
{
	CLine *l = m_lines[pos];

	//Repositiong line
	if(pos<m_numLines-1)
	{
		for(int i=pos+1; i<m_numLines;i++)
		{
			CLine *Lcurr = m_lines[i];
			m_lines[i-1] = Lcurr;
		}

		//Delete last line
		m_lines[m_numLines-1] = NULL;
	}

	delete l;
	m_numLines--;
}

CLine* CConnector::GetLine(int i)
{
	return m_lines[i];
}

long CConnector::GetNumLines()
{
	return m_numLines;
}

void CConnector::Draw(WindowInfo *win, HDC hdc)
{
	int deltaAnc = 5;

	//DrawLine
	for(int i=0; i<m_numLines;i++)
	{
		CLine *l = GetLine(i);

		POINT p1,p2;
		bool bVis1 = ConvertPointToWinEX(l->m_P1, &p1, win);
		bool bVis2 = ConvertPointToWinEX(l->m_P2, &p2, win);

		HPEN penUsed;
		HGDIOBJ prevPen;
		LOGPEN  pen;
		if(m_IsSelected == true)
		{
			pen.lopnStyle = PS_SOLID;
			pen.lopnWidth.x = 1;
			pen.lopnWidth.y = 1;
			pen.lopnColor = _LINE_SEL_COLOR_;
			penUsed = CreatePenIndirect(&pen);
		}
		else
		{
			pen.lopnStyle = PS_SOLID;
			pen.lopnWidth.x = 1;
			pen.lopnWidth.y = 1;
			pen.lopnColor = m_Color; //_LINE_COLOR_;
			penUsed = CreatePenIndirect(&pen);
		}

		prevPen = SelectObject(hdc, penUsed);

		//Draw rectangle if selected...
		if(m_IsSelected == true)
		{
			RECT rA;
			POINT p = p1;
			rA.left = p1.x - deltaAnc;
			rA.top = p1.y - deltaAnc;
			rA.right = p1.x + deltaAnc;
			rA.bottom = p1.y + deltaAnc;

			Rectangle(hdc, rA.left, rA.top, rA.right, rA.bottom);

			rA.left = p2.x - deltaAnc;
			rA.top = p2.y - deltaAnc;
			rA.right = p2.x + deltaAnc;
			rA.bottom = p2.y + deltaAnc;

			Rectangle(hdc, rA.left, rA.top, rA.right, rA.bottom);
		}

		MoveToEx(hdc, p1.x, p1.y, NULL);
		LineTo(hdc, p2.x, p2.y);

		SelectObject(hdc, prevPen);
		DeleteObject(penUsed);
	}

	//Draw indicator
	if(m_PosIndicatore==_POS_INDICATORE_FINE_TRATTO)
	{
		if(m_StopNotaLinked!=NULL)
		{
			DrawArrowOnNote(win, hdc, m_StopNotaLinked);
		}
		else
			DrawArrow(win, hdc);
	}
}

void CConnector::DrawArrow(WindowInfo *win, HDC hdc)
{
	if(m_TipoIndicatore==_INDICATORE_FRECCIA_)
	{
		CLine *Line ;
		if(m_PosIndicatore == _POS_INDICATORE_FINE_TRATTO)
			Line = GetLine(GetNumLines()-1);
		else
			Line = GetLine(0);

		POINT p1S, p2S;
		ConvertPointToWinEX(Line->m_P1, &p1S, win);
		ConvertPointToWinEX(Line->m_P2, &p2S, win);

		PointD p1Line, p2Line;
		p1Line.x = p1S.x;
		p1Line.y = p1S.y;

		p2Line.x = p2S.x;
		p2Line.y = p2S.y;

		double LungLine = sqrt(powl((p1Line.x-p2Line.x),2) + powl((p1Line.y-p2Line.y),2));

		PointD pIntersezione = p2Line;
		double distMin = LungLine;

		//Calcolo la posizione della base della freccia
		if(distMin-10>0)
			distMin = distMin-10;
		double ang = GetAngoloFromPoints(p1Line, pIntersezione);
		if(ang!=0.00)
			ang = 2*_PI_GRECO - ang;
		PointD pBaseFreccia = CalcolaPointRispettoPoint(p1Line,distMin,ang);

		double angMag90 = ang + _PI_GRECO/2;
		while(angMag90>2*_PI_GRECO)
			angMag90 -= 2*_PI_GRECO;

		PointD p1Freccia = CalcolaPointRispettoPoint(pBaseFreccia, 5, angMag90);

		double angMin90 = ang - _PI_GRECO/2;
		while(angMin90<0)
			angMin90+=2*_PI_GRECO;

		PointD p2Freccia = CalcolaPointRispettoPoint(pBaseFreccia, 5, angMin90);

		POINT pts[3];
		pts[0].x = pIntersezione.x;
		pts[0].y = pIntersezione.y;

		pts[1].x = p1Freccia.x;
		pts[1].y = p1Freccia.y;

		pts[2].x = p2Freccia.x;
		pts[2].y = p2Freccia.y;

		COLORREF color;
		HPEN penUsed;
		HGDIOBJ prevPen;
		LOGPEN  pen;
		if(m_IsSelected == true)
		{
			color = _LINE_SEL_COLOR_;
			pen.lopnStyle = PS_SOLID;
			pen.lopnWidth.x = 1;
			pen.lopnWidth.y = 1;
			pen.lopnColor = _LINE_SEL_COLOR_;
			penUsed = CreatePenIndirect(&pen);
		}
		else
		{
			color = m_Color; //_LINE_COLOR_;
			pen.lopnStyle = PS_SOLID;
			pen.lopnWidth.x = 1;
			pen.lopnWidth.y = 1;
			pen.lopnColor = m_Color; //_LINE_COLOR_;
			penUsed = CreatePenIndirect(&pen);
		}
		
		prevPen = SelectObject(hdc, penUsed);

		HBRUSH brush = CreateSolidBrush(color);
		HGDIOBJ pOldBrush = SelectObject(hdc, brush);

		Polygon(hdc, pts, 3);

		SelectObject(hdc, pOldBrush);
		DeleteObject(brush);

		SelectObject(hdc, prevPen);
		DeleteObject(penUsed);
	}
}

void CConnector::DrawArrowOnNote(WindowInfo *win, HDC hdc, CNote *note)
{
	if(m_TipoIndicatore==_INDICATORE_FRECCIA_)
	{
		CLine *Line ;
		if(m_PosIndicatore == _POS_INDICATORE_FINE_TRATTO)
			Line = GetLine(GetNumLines()-1);
		else
			Line = GetLine(0);

		POINT p1S, p2S;
		ConvertPointToWinEX(Line->m_P1, &p1S, win);
		ConvertPointToWinEX(Line->m_P2, &p2S, win);

		PointD p1Line, p2Line;
		p1Line.x = p1S.x;
		p1Line.y = p1S.y;

		p2Line.x = p2S.x;
		p2Line.y = p2S.y;


		double LungLine = sqrt(powl((p1Line.x-p2Line.x),2) + powl((p1Line.y-p2Line.y),2));

		//Load Note points
		POINT p1_S,p2_S,p3_S,p4_S;
		CPageLinkedPoint p1L_S,p2L_S,p3L_S,p4L_S;
		note->FindNotePoints(&p1L_S, &p2L_S, &p3L_S, &p4L_S);

		ConvertPointToWinEX(p1L_S, &p1_S, win);
		ConvertPointToWinEX(p2L_S, &p2_S, win);
		ConvertPointToWinEX(p3L_S, &p3_S, win);
		ConvertPointToWinEX(p4L_S, &p4_S, win);

		PointD p1,p2,p3,p4;
		p1.set(p1_S.x, p1_S.y);
		p2.set(p2_S.x, p2_S.y);
		p3.set(p3_S.x, p3_S.y);
		p4.set(p4_S.x, p4_S.y);

		//Determino l'intersezione della linea passante per i due punti p1Line e p2Line
		//e le rette passanti per i 4 vertici del rettangolo
		
		PointD pIntersezione, p1Freccia, p2Freccia;

		double A = (p2.x - p1.x);
		double B = (p1Line.y - p1.y);
		double C = (p2.y - p1.y);
		double D = (p1Line.x - p1.x);
		double E = (p2.y - p1.y);
		double F = (p2Line.x - p1Line.x);
		double G = (p2.x - p1.x);
		double H = (p2Line.y - p1Line.y);
		double Ua = 0.0;
		double IntX = 0.0;
		double IntY = 0.0;
		double distMin = 10000;
		double dist = distMin + 1;
		PointD pSup;
		if((E * F - G * H)!=0)
		{
			Ua = (A * B - C * D) / (E * F - G * H);
		
			IntX = p1Line.x + Ua * (p2Line.x - p1Line.x) ;
			IntY = p1Line.y + Ua * (p2Line.y - p1Line.y) ;

			//Calcolo la distanza dal primo punto...
			dist = sqrt(pow((p1Line.x-IntX),2) + pow((p1Line.y-IntY),2));
			pSup.x = (long)(IntX+0.5);
			pSup.y = (long)(IntY+0.5);
			if(dist<distMin && IsPointBetweenPoints(pSup, p1Line, p2Line)==TRUE
				&& IsPointBetweenPoints(pSup,p1,p2)==TRUE)
			{
				distMin = dist;
				pIntersezione.x = (long)(IntX+0.5);
				pIntersezione.y = (long)(IntY+0.5);
			}
		}

		//SecondaLinea - Rettangolo
		A = (p3.x - p2.x);
		B = (p1Line.y - p2.y);
		C = (p3.y - p2.y);
		D = (p1Line.x - p2.x);
		E = (p3.y - p2.y);
		F = (p2Line.x - p1Line.x);
		G = (p3.x - p2.x);
		H = (p2Line.y - p1Line.y);
		
		if((E * F - G * H)!=0)
		{
			Ua = (A * B - C * D) / (E * F - G * H);

			
			IntX = p1Line.x + Ua * (p2Line.x - p1Line.x) ;
			IntY = p1Line.y + Ua * (p2Line.y - p1Line.y) ;

			//Calcolo la distanza dal primo punto...
			dist = sqrt(pow((p1Line.x-IntX),2) + pow((p1Line.y-IntY),2));
			pSup.x = (long)(IntX+0.5);
			pSup.y = (long)(IntY+0.5);
			if(dist<distMin && IsPointBetweenPoints(pSup, p1Line, p2Line)==TRUE
				&& IsPointBetweenPoints(pSup,p2,p3)==TRUE)
			{
				distMin = dist;
				pIntersezione.x = (long)(IntX+0.5);
				pIntersezione.y = (long)(IntY+0.5);
			}
		}

		//TerzaLinea - Rettangolo
		A = (p4.x - p3.x);
		B = (p1Line.y - p3.y);
		C = (p4.y - p3.y);
		D = (p1Line.x - p3.x);
		E = (p4.y - p3.y);
		F = (p2Line.x - p1Line.x);
		G = (p4.x - p3.x);
		H = (p2Line.y - p1Line.y);
		
		if((E * F - G * H)!=0)
		{
			Ua = (A * B - C * D) / (E * F - G * H);
			
			IntX = p1Line.x + Ua * (p2Line.x - p1Line.x) ;
			IntY = p1Line.y + Ua * (p2Line.y - p1Line.y) ;

			//Calcolo la distanza dal primo punto...
			dist = sqrt(pow((p1Line.x-IntX),2) + pow((p1Line.y-IntY),2));
			pSup.x = (long)(IntX+0.5);
			pSup.y = (long)(IntY+0.5);
			if(dist<distMin && IsPointBetweenPoints(pSup, p1Line, p2Line)==TRUE
				&& IsPointBetweenPoints(pSup,p3,p4)==TRUE)
			{
				distMin = dist;
				pIntersezione.x = (long)(IntX+0.5);
				pIntersezione.y = (long)(IntY+0.5);
			}
		}

		//QuartaLinea - Rettangolo
		A = (p1.x - p4.x);
		B = (p1Line.y - p4.y);
		C = (p1.y - p4.y);
		D = (p1Line.x - p4.x);
		E = (p1.y - p4.y);
		F = (p2Line.x - p1Line.x);
		G = (p1.x - p4.x);
		H = (p2Line.y - p1Line.y);

		if((E * F - G * H)!=0)
		{
			Ua = (A * B - C * D) / (E * F - G * H);
			
			IntX = p1Line.x + Ua * (p2Line.x - p1Line.x) ;
			IntY = p1Line.y + Ua * (p2Line.y - p1Line.y) ;

			//Calcolo la distanza dal primo punto...
			dist = sqrt(pow((p1Line.x-IntX),2) + pow((p1Line.y-IntY),2));
			pSup.x = (long)(IntX+0.5);
			pSup.y = (long)(IntY+0.5);
			if(dist<distMin && IsPointBetweenPoints(pSup, p1Line, p2Line)==TRUE
				&& IsPointBetweenPoints(pSup,p4,p1)==TRUE)
			{
				distMin = dist;
				pIntersezione.x = (long)(IntX+0.5);
				pIntersezione.y = (long)(IntY+0.5);
			}
		}

		if(distMin<10000)
		{
			//Ho interceettato il Punto di Intersezione

			//Calcolo la posizione della base della freccia
			if(distMin-10>0)
				distMin = distMin-10;
			double ang = GetAngoloFromPoints(p1Line, pIntersezione);
			if(ang!=0.00)
				ang = 2*_PI_GRECO - ang;
			PointD pBaseFreccia = CalcolaPointRispettoPoint(p1Line,distMin,ang);

			double angMag90 = ang + _PI_GRECO/2;
			while(angMag90>2*_PI_GRECO)
				angMag90 -= 2*_PI_GRECO;

			p1Freccia = CalcolaPointRispettoPoint(pBaseFreccia, 5, angMag90);

			double angMin90 = ang - _PI_GRECO/2;
			while(angMin90<0)
				angMin90+=2*_PI_GRECO;

			p2Freccia = CalcolaPointRispettoPoint(pBaseFreccia, 5, angMin90);

			POINT pts[3];
			pts[0].x = pIntersezione.x;
			pts[0].y = pIntersezione.y;

			pts[1].x = p1Freccia.x;
			pts[1].y = p1Freccia.y;

			pts[2].x = p2Freccia.x;
			pts[2].y = p2Freccia.y;

			COLORREF color;
			HPEN penUsed;
			HGDIOBJ prevPen;
			LOGPEN  pen;
			if(m_IsSelected == true)
			{
				color = _LINE_SEL_COLOR_;
				pen.lopnStyle = PS_SOLID;
				pen.lopnWidth.x = 1;
				pen.lopnWidth.y = 1;
				pen.lopnColor = _LINE_SEL_COLOR_;
				penUsed = CreatePenIndirect(&pen);
			}
			else
			{
				color = m_Color; //_LINE_COLOR_;
				pen.lopnStyle = PS_SOLID;
				pen.lopnWidth.x = 1;
				pen.lopnWidth.y = 1;
				pen.lopnColor = m_Color;//_LINE_COLOR_;
				penUsed = CreatePenIndirect(&pen);
			}
			
			prevPen = SelectObject(hdc, penUsed);

			HBRUSH brush = CreateSolidBrush(color);
			HGDIOBJ pOldBrush = SelectObject(hdc, brush);

			Polygon(hdc, pts, 3);

			SelectObject(hdc, pOldBrush);
			DeleteObject(brush);

			SelectObject(hdc, prevPen);
			DeleteObject(penUsed);
		}
	}
}

bool CConnector::IsPointInAncorage(WindowInfo *win, CPageLinkedPoint pInsert)
{
	bool ret = false;
	int deltaAnc = 5;

	POINT p;
	p.x = pInsert.m_p.x;
	p.y = pInsert.m_p.y;

	for(int i=0; i<GetNumLines(); i++)
	{
		CLine *l = GetLine(i);

		POINT p1;
		p1.x = l->m_P1.m_p.x;
		p1.y = l->m_P1.m_p.y;

		POINT p2;
		p2.x = l->m_P2.m_p.x;
		p2.y = l->m_P2.m_p.y;

		//Primo punto
		RECT rA;
		rA.left = p1.x - deltaAnc;
		rA.top = p1.y - deltaAnc;
		rA.right = p1.x + deltaAnc;
		rA.bottom = p1.y + deltaAnc;

		if(PtInRect(&rA, p) == TRUE)
		{
			m_1LineSelected = i-1;
			m_2LineSelected = i;

			ret = true;
			break;
		}

		//Secondo punto
		rA.left = p2.x - deltaAnc;
		rA.top = p2.y - deltaAnc;
		rA.right = p2.x + deltaAnc;
		rA.bottom = p2.y + deltaAnc;

		if(PtInRect(&rA, p) == TRUE)
		{
			m_1LineSelected = i;
			m_2LineSelected = i+1;

			ret = true;
			break;
		}
	}

	return ret;
}

//------------------------------------CPointLinked-----------------------------------------------
//-----------------------------------------------------------------------------------------------
CPageLinkedPoint::CPageLinkedPoint(void)
{
	m_pdfPage = NULL;
}

CPageLinkedPoint::CPageLinkedPoint(PdfPageInfo *page, POINT p)
{
	m_pdfPage = page;
	m_p.set(p.x, p.y);
}
void CPageLinkedPoint::Set(CPageLinkedPoint *p)
{
	m_pdfPage = p->m_pdfPage;
	m_p = p->m_p;
	m_numPage = p->GetNumPage();
}