#include "NoteDlg.h"

#include "Richedit.h"


HWND CNoteDlg::m_hWindow = NULL;
long CNoteDlg::m_lSaveThis = 0;
BOOL CNoteDlg::m_bOK = FALSE;
CString CNoteDlg::m_strNote = "";
HFONT CNoteDlg::m_hfont = NULL;
COLORREF CNoteDlg::m_fontColor = RGB(0,0,0);
HFONT CNoteDlg::m_hfontNote = NULL;
COLORREF CNoteDlg::m_fontColorNote = RGB(0,0,0);

static DWORD __stdcall MEditStreamInCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb)
{
	CString *psBuffer = (CString *)dwCookie;

	if (cb > psBuffer->GetLength()) cb = psBuffer->GetLength();

	for (int i=0;i<cb;i++) {
		*(pbBuff+i) = psBuffer->GetAt(i);
	}

	*pcb = cb;

	*psBuffer = psBuffer->Mid(cb);

	return 0;
}


static DWORD __stdcall MEditStreamOutCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb)
{
	CString sThisWrite;
	sThisWrite.GetBufferSetLength(cb);

	CString *psBuffer = (CString *)dwCookie;
	
	for (int i=0;i<cb;i++) {
		sThisWrite.SetAt(i,*(pbBuff+i));
	}

	*psBuffer += sThisWrite;

	*pcb = sThisWrite.GetLength();
	sThisWrite.ReleaseBuffer();
	return 0;
}

static HRESULT CharFormatFromHFONT(CHARFORMAT2W* pCF, HFONT hFont, COLORREF FontColor)
// Takes an HFONT and fills in a CHARFORMAT2W structure with the corresponding info
{

	HWND hWnd;
	LOGFONT lf;
	HDC hDC;
	LONG yPixPerInch;

	// Get LOGFONT for default font
	if (!hFont)
		hFont = (HFONT) GetStockObject(SYSTEM_FONT);

	// Get LOGFONT for passed hfont
	if (!GetObject(hFont, sizeof(LOGFONT), &lf))
		return E_FAIL;

	// Set CHARFORMAT structure
	memset(pCF, 0, sizeof(CHARFORMAT2W));
	pCF->cbSize = sizeof(CHARFORMAT2W);

	hWnd = GetDesktopWindow();
	hDC = GetDC(hWnd);
	yPixPerInch = GetDeviceCaps(hDC, LOGPIXELSY);
	pCF->yHeight = -lf.lfHeight * LY_PER_INCH / yPixPerInch;
	ReleaseDC(hWnd, hDC);

	pCF->yOffset = 0;
	pCF->crTextColor = 0;

	pCF->dwEffects = CFM_EFFECTS | CFE_AUTOBACKCOLOR;
	pCF->dwEffects &= ~(CFE_PROTECTED | CFE_LINK | CFE_AUTOCOLOR);

	if(lf.lfWeight < FW_BOLD)
		pCF->dwEffects &= ~CFE_BOLD;

	if(!lf.lfItalic)
		pCF->dwEffects &= ~CFE_ITALIC;

	if(!lf.lfUnderline)
		pCF->dwEffects &= ~CFE_UNDERLINE;

	if(!lf.lfStrikeOut)
		pCF->dwEffects &= ~CFE_STRIKEOUT;

	pCF->dwMask = CFM_ALL | CFM_BACKCOLOR | CFM_STYLE;
	pCF->bCharSet = lf.lfCharSet;
	pCF->bPitchAndFamily = lf.lfPitchAndFamily;

#ifdef UNICODE
	_tcscpy(pCF->szFaceName, lf.lfFaceName);
#else
	MultiByteToWideChar(CP_ACP, 0, lf.lfFaceName, LF_FACESIZE, pCF->szFaceName, LF_FACESIZE);
#endif

	if(FontColor != NULL)
		pCF->crTextColor = FontColor;

	return S_OK;
}

CNoteDlg::CNoteDlg(int nResId, HWND hParent)
{
	m_lSaveThis = (long)this; /// store this pointer

	m_nResId = nResId;
	m_hParent = hParent;

}

CNoteDlg::~CNoteDlg()
{
	m_hWindow = NULL;
	m_lSaveThis = 0;
}

int CNoteDlg::DoModal(void)
{
	int retVal = (DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(m_nResId), m_hParent, DialogProcStatic));
	return m_bOK;
}

BOOL CALLBACK CNoteDlg::DialogProcStatic(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	if(m_hWindow == NULL)
	{
		m_hWindow = hDlg;
	}

	CNoteDlg *pThis = (CNoteDlg*)m_lSaveThis; /// typecast stored this-pointer to CBaseDialog pointer

	int r = (int)LoadLibrary("riched20.dll");

	if(message == WM_NOTIFY )
	{

	}
	else
	{
		switch(message)
		{
		case WM_INITDIALOG:
			{
				m_bOK = FALSE;

				HWND hRichEdit = NULL;
				hRichEdit = GetDlgItem(hDlg, IDC_RICHEDIT);

				EDITSTREAM es;
				CString sWriteText;
				if(m_strNote == "")
					sWriteText = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1040{\\fonttbl{\\f0\\fnil\\fcharset0 Arial;}}\\viewkind4\\uc1\\pard\\f0\\fs17 Nota\\par}";
				else
					sWriteText = m_strNote;

				es.dwCookie = (DWORD)&sWriteText;			// Pass a pointer to the CString to the callback function
				es.pfnCallback = MEditStreamInCallback;		// Specify the pointer to the callback function

				// Send message
				SendMessage(hRichEdit, EM_STREAMIN, (WPARAM)SF_RTF, (LPARAM)&es);

				//Init font for viewing note
				CHARFORMAT2W *pCF;
				pCF = (CHARFORMAT2W*) malloc(sizeof(CHARFORMAT2W));
				CharFormatFromHFONT(pCF, m_hfont, m_fontColor);

				SendMessage(hRichEdit, EM_SETCHARFORMAT, SCF_ALL, (LPARAM)(pCF));

				delete[] pCF;

				//Set Dialog in correct position
				if(GetParent(hDlg))
				{
					RECT rParent;
					GetWindowRect(GetParent(hDlg), &rParent);
					RECT rDlg;
					GetClientRect(hDlg,&rDlg);

					SetWindowPos(hDlg, GetParent(hDlg), (rParent.right + rParent.left)/2 - (rDlg.right - rDlg.left)/2, (rParent.top + rParent.bottom)/2, rDlg.right - rDlg.left, rDlg.bottom - rDlg.top + 25, NULL);
				}

			}
			return TRUE;

		case WM_COMMAND:
			switch(wParam)
			{
			case IDOK:
				{
					//-->save Text

					//Individuo il RichEdit
					HWND hRichEdit = NULL;
					hRichEdit = GetDlgItem(hDlg, IDC_RICHEDIT);

					//set the correct font of the note

					CHARFORMAT2W *pCF;
					pCF = (CHARFORMAT2W*) malloc(sizeof(CHARFORMAT2W));
					CharFormatFromHFONT(pCF, m_hfontNote, m_fontColorNote);

					SendMessage(hRichEdit, EM_SETCHARFORMAT, SCF_ALL, (LPARAM)(pCF));

					delete[] pCF;

					//Leggo la nota
					EDITSTREAM es;
					CString sWriteText = "";
					es.dwCookie = (DWORD)&sWriteText;			// Pass a pointer to the CString to the callback function
					es.pfnCallback = MEditStreamOutCallback;		// Specify the pointer to the callback function
					SendMessage(hRichEdit, EM_STREAMOUT, (WPARAM)SF_RTF, (LPARAM)&es);

					//Salvo l'RTF
					m_strNote = sWriteText;
					
					m_bOK = TRUE;
					EndDialog(hDlg, 0);
					return TRUE;
				}
			case IDCANCEL:
				{
					m_strNote = "";
					m_bOK = FALSE;
					EndDialog(hDlg, 0);
					return FALSE;
				}
			}
			break;
		}
	}
	return FALSE;
}

