#pragma once

#include "resource.h"       // main symbols

//#include "SumatraPdf.h"

#include <atlstr.h>
#include <atlconv.h>

#include <richedit.h>
#include <textserv.h>

const IID IID_ITextServices = { // 8d33f740-cf58-11ce-a89d-00aa006cadc5
    0x8d33f740,
    0xcf58,
    0x11ce,
    {0xa8, 0x9d, 0x00, 0xaa, 0x00, 0x6c, 0xad, 0xc5}
  };

const IID IID_ITextHost = { // c5bdd8d0-d26e-11ce-a89e-00aa006cadc5
    0xc5bdd8d0,
    0xd26e,
    0x11ce,
    {0xa8, 0x9e, 0x00, 0xaa, 0x00, 0x6c, 0xad, 0xc5}
  };

#define LY_PER_INCH   1440
#define HOST_BORDER 0

/////////////////////////////////////////////////////////////////////////////
// IRtf2Bmp

//interface IRtf2Bmp
//{
//public:
//	virtual ~IRtf2Bmp() {};
//	virtual HRESULT get_NaturalHeight(long Width, /*[out, retval]*/ long *pVal) = 0;
//	virtual HRESULT get_NaturalWidth(long Height, /*[out, retval]*/ long *pVal) = 0;
//	virtual HRESULT get_NaturalSize(long *Height, long *Width) = 0;
//	virtual HRESULT Create() = 0;
//	virtual HRESULT Draw(void *hdcDraw, RECT *prc) = 0;
//	virtual HRESULT get_RTFText(/*[out, retval]*/ /*BSTR *pVal*/ CString *str) = 0;
//	virtual HRESULT put_RTFText(/*[in]*/ /*BSTR newVal*/ CString str) = 0;
//
//	virtual HBITMAP CreateBMP(void *hdc, long xPos, long yPos, RECT &rBitmap)=0;
//	virtual void	setZoom(double zoom)=0;
//	virtual void	setParent(HWND hParent)=0;
//
//
//// COM-like functions
//    virtual ULONG STDMETHODCALLTYPE AddRef(void) = 0;
//    virtual ULONG STDMETHODCALLTYPE Release(void) = 0;
//};

class CRtf2Bmp: public ITextHost
//	public ITextHost,
//	public IRtf2Bmp
{
public:
	CRtf2Bmp(void);
public:
	~CRtf2Bmp(void);

// Minimal COM functionality
    HRESULT STDMETHODCALLTYPE QueryInterface( 
        /* [in] */ REFIID riid,
        /* [iid_is][out] */ void __RPC_FAR *__RPC_FAR *ppvObject)
	{
		*ppvObject = NULL;
		return S_FALSE;
	}
    
    ULONG STDMETHODCALLTYPE AddRef(void)
	{
		return 0;
	}
    
    ULONG STDMETHODCALLTYPE Release(void)
	{
		return 0;
	}

// IRtf2Bmp
public:
	HRESULT get_NaturalHeight(long Width, /*[out, retval]*/ long *pVal);
	HRESULT get_NaturalWidth(long Height, /*[out, retval]*/ long *pVal);
	HRESULT get_NaturalSize(long *Height, long *Width);
	HRESULT Create();
	HRESULT Draw(void *hdcDraw, RECT *prc);
	HRESULT get_RTFText(/*[out, retval]*/ /*BSTR *pVal*/ CString *str);
	HRESULT put_RTFText(/*[in]*/ /*BSTR newVal*/ CString str);
	void	setZoom(double zoom);
	void	setParent(HWND hParent);

	HBITMAP CreateBMP(CString str, HDC hdc, long *wBitmap, long *hBitmap);
	HBITMAP ModifyFontRTF(HDC hdc, CString str, HFONT hfont, COLORREF fontColor, long *w, long *h);


// ITextHost
	HDC TxGetDC();
	INT TxReleaseDC(HDC hdc);
	BOOL TxShowScrollBar(INT fnBar, BOOL fShow);
	BOOL TxEnableScrollBar(INT fuSBFlags, INT fuArrowflags);
	BOOL TxSetScrollRange(INT fnBar, LONG nMinPos, INT nMaxPos, BOOL fRedraw);
	BOOL TxSetScrollPos(INT fnBar, INT nPos, BOOL fRedraw);
	void TxInvalidateRect(LPCRECT prc, BOOL fMode);
	void TxViewChange(BOOL fUpdate);
	BOOL TxCreateCaret(HBITMAP hbmp, INT xWidth, INT yHeight);
	BOOL TxShowCaret(BOOL fShow);
	BOOL TxSetCaretPos(INT x, INT y);
	BOOL TxSetTimer(UINT idTimer, UINT uTimeout);
	void TxKillTimer(UINT idTimer);
	void TxScrollWindowEx(INT dx, INT dy, LPCRECT lprcScroll, LPCRECT lprcClip, HRGN hrgnUpdate, LPRECT lprcUpdate, UINT fuScroll);
	void TxSetCapture(BOOL fCapture);
	void TxSetFocus();
	void TxSetCursor(HCURSOR hcur, BOOL fText);
	BOOL TxScreenToClient(LPPOINT lppt);
	BOOL TxClientToScreen(LPPOINT lppt);
	HRESULT	TxActivate(LONG * plOldState);
	HRESULT	TxDeactivate(LONG lNewState);
	HRESULT	TxGetClientRect(LPRECT prc);
	HRESULT	TxGetViewInset(LPRECT prc);
	HRESULT TxGetCharFormat(const CHARFORMATW **ppCF);
	HRESULT	TxGetParaFormat(const PARAFORMAT **ppPF);
	COLORREF TxGetSysColor(int nIndex);
	HRESULT	TxGetBackStyle(TXTBACKSTYLE *pstyle);
	HRESULT	TxGetMaxLength(DWORD *plength);
	HRESULT	TxGetScrollBars(DWORD *pdwScrollBar);
	HRESULT	TxGetPasswordChar(TCHAR *pch);
	HRESULT	TxGetAcceleratorPos(LONG *pcp);
	HRESULT	TxGetExtent(LPSIZEL lpExtent);
	HRESULT OnTxCharFormatChange(const CHARFORMATW * pcf);
	HRESULT	OnTxParaFormatChange(const PARAFORMAT * ppf);
	HRESULT	TxGetPropertyBits(DWORD dwMask, DWORD *pdwBits);
	HRESULT	TxNotify(DWORD iNotify, void *pv);
	HIMC TxImmGetContext();
	void TxImmReleaseContext(HIMC himc);
	HRESULT	TxGetSelectionBarWidth(LONG *lSelBarWidth);

//Custom functions
	HRESULT CharFormatFromHFONT(CHARFORMAT2W* pCF, HFONT hFont, COLORREF fontColor=NULL);
	HRESULT InitDefaultCharFormat();
	HRESULT InitDefaultParaFormat();
	HRESULT CreateTextServicesObject();


	//Variables
	double m_zoom;

	RECT			m_rcClient;			// Client Rect
	RECT			m_rcViewInset;		// view rect inset
	SIZEL			m_sizelExtent;		// Extent array

	int				nPixelsPerInchX;    // Pixels per logical inch along width
	int				nPixelsPerInchY;    // Pixels per logical inch along height

	CHARFORMAT2W	*m_pCF;
	PARAFORMAT2		m_PF;
	DWORD			m_dwScrollbar;		// Scroll bar style
	DWORD			m_dwPropertyBits;	// Property bits
	DWORD			m_dwMaxLength;

	HWND			m_wndParent;

	ITextServices	*m_spTextServices;
	CString			m_rtf;
};
