#pragma once

#include "SumatraPdf.h"

#include "Rtf2Bmp.h"

#include <atlstr.h>
#include <atlconv.h>

enum PNSCommand
{
	CMD_NO_CMD = -1,
	CMD_NEW_UNDERLINE_P1,
	CMD_NEW_UNDERLINE_P2,
	CMD_LINE_SEL,
	CMD_NEW_HIGHLIGHT_P1,
	CMD_NEW_HIGHLIGHT_P2,
	CMD_HIGHLIGHT_SEL,
	CMD_NEW_NOTE,
	CMD_NOTE_SEL,
	CMD_NOTE_MOVE,
	CMD_NEW_CONNECTOR,
	CMD_NEW_CONNECTOR_END_ON_NOTE,
	CMD_CONNECTOR_SEL,
	CMD_CONNECTOR_ANCORAGE_SEL
};


#define _PI_GRECO					3.1415926535898

//Colour
#define _ULINE_SEL_COLOR_			RGB(0,255,0)
#define _ULINE_COLOR_				RGB(255,0,0)
#define _LINE_SEL_COLOR_			RGB(193,164,62)
#define _LINE_COLOR_				RGB(0,0,255)
#define _NOTE_SEL_COLOR_			RGB(255,0,0)
#define _NOTE_COLOR_				RGB(0,0,0)

//Connector Constant
#define _INDICATORE_NO_					0
#define _INDICATORE_FRECCIA_			1

#define _POS_INDICATORE_FINE_TRATTO		1
#define _POS_INDICATORE_INIZIO_TRATTO	2

//Height HighLight
#define _HEIGHT_8PT						8
#define _HEIGHT_9PT						9
#define _HEIGHT_10PT					10
#define _HEIGHT_11PT					11
#define _HEIGHT_12PT					12
#define _HEIGHT_13PT					13
#define _HEIGHT_14PT					14
#define _HEIGHT_15PT					15
#define _HEIGHT_16PT					16
#define _HEIGHT_17PT					17
#define _HEIGHT_18PT					18
#define _HEIGHT_19PT					19
#define _HEIGHT_20PT					20


//-----------------Tag for save pdfnotes
#define _PDFNOTES_I_						"<PDF_NOTE>"
#define _PDFNOTES_F_						"</PDF_NOTE>"
#define _INFO_I_							"<INFO>"
#define _INFO_F_							"</INFO>"
#define _PDF_I_								"<PDF>"
#define _PDF_FILE_NAME_						"<PDF_FILE_NAME>"
#define _PDF_TOTPAGE_						"<PDF_TOTPAGE>"
#define _PDF_ZOOM_							"<PDF_ZOOM>"
#define _PDF_XORIGIN_						"<PDF_XORIGIN>"
#define _PDF_F_								"</PDF>"
#define _SETTINGS_I_						"<SETTINGS_I>"
#define _SETTINGS_NOTE_FONT_COLOR_			"<SETTINGS_NOTE_FONT_COLOR>"
#define _SETTINGS_NOTE_FONT_FACE_			"<SETTINGS_NOTE_FONT_FACE>"
#define _SETTINGS_NOTE_FONT_HEIGHT_			"<SETTINGS_NOTE_FONT_HEIGHT>"
#define _SETTINGS_NOTE_FONT_ITALIC_			"<SETTINGS_NOTE_FONT_ITALIC>"
#define _SETTINGS_NOTE_FONT_BOLD_			"<SETTINGS_NOTE_FONT_BOLD>"
#define _SETTINGS_ULINE_COLOR_				"<SETTINGS_ULINE_COLOR>"
#define _SETTINGS_CONNECTOR_COLOR_			"<SETTINGS_CONNECTOR_COLOR>"
#define _SETTINGS_F_						"<SETTINGS_F>"
#define _NOTES_I_							"<NOTES>"
#define _NOTES_F_							"</NOTES>"
#define _NOTE_I_							"<NOTE>"
#define _NOTE_CENTER_X_						"<NOTE_CENTER_X>"
#define _NOTE_CENTER_Y_						"<NOTE_CENTER_Y>"
#define _NOTE_CENTER_NUMPAGE_				"<NOTE_CENTER_NUMPAGE>"
#define _NOTE_WIDTH_						"<NOTE_WIDTH>"
#define _NOTE_HEIGHT_						"<NOTE_HEIGHT>"
#define _NOTE_RTF_I_						"<NOTE_RTF>"
#define _NOTE_RTF_F_						"</NOTE_RTF>"
#define _NOTE_CONNECTOR_I_					"<NOTA_CONNECTOR>"
#define _NOTE_CONNECTOR_F_					"</NOTA_CONNECTOR>"
#define _NOTE_FONT_COLOR_					"<NOTE_FONT_COLOR>"
#define _NOTE_FONT_FACE_					"<NOTE_FONT_FACE>"
#define _NOTE_FONT_HEIGHT_					"<NOTE_FONT_HEIGHT>"
#define _NOTE_FONT_ITALIC_					"<NOTE_FONT_ITALIC>"
#define _NOTE_FONT_BOLD_					"<NOTE_FONT_BOLD>"
#define _NOTE_F_							"</NOTE>"
#define _CONNECTORS_I_						"<CONNECTORS>"
#define _CONNECTORS_F_						"</CONNECTORS>"
#define _CONNECTOR_I_						"<CONNECTOR>"
#define _CONNECTOR_TIPO_INDICATORE_			"<CONNECTOR_TIPO_INDICATORE>"
#define _CONNECTOR_POS_INDICATORE_			"<CONNECTOR_POS_INDICATORE>"
#define _CONNECTOR_COLOR_					"<CONNECTOR_COLOR>"
#define _CONNECTOR_NOTE_LINKED_I_			"<CONNECTOR_NOTE_LINKED>"
#define _CONNECTOR_NOTE_LINKED_F_			"</CONNECTOR_NOTE_LINKED>"
#define _CONNECTOR_LINES_I					"<CONNECTOR_LINES>"
#define _CONNECTOR_LINES_F					"</CONNECTOR_LINES>"
#define _CONNECTOR_LINE_I					"<CONNECTOR_LINE>"
#define _CONNECTOR_LINE_F					"</CONNECTOR_LINE>"
#define _CONNECTOR_F_						"</CONNECTOR>"
#define _ULINES_I_							"<ULINES>"
#define _ULINES_F_							"</ULINES>"
#define _ULINE_I_							"<ULINE>"
#define _ULINE_PAGE_I_						"<ULINE_PAGE>"
#define _ULINE_PAGE_F_						"</ULINE_PAGE>"
#define _ULINE_POINTS_I_					"<ULINE_POINTS>"
#define _ULINE_POINTS_F_					"</ULINE_POINTS>"
#define _ULINE_COLOR_I_						"<ULINE_COLOR_I>"
#define _ULINE_COLOR_F_						"<ULINE_COLOR_F>"
#define _ULINE_F_							"</ULINE>"
#define _HLIGHTS_I_							"<HLIGHTS>"
#define _HLIGHTS_F_							"</HLIGHTS>"
#define _HLIGHT_I_							"<HLIGHT>"
#define _HLIGHT_PAGE_I_						"<HLIGHT_PAGE>"
#define _HLIGHT_PAGE_F_						"</HLIGHT_PAGE>"
#define _HLIGHT_POINTS_I_					"<HLIGHT_POINTS>"
#define _HLIGHT_POINTS_F_					"</HLIGHT_POINTS>"
#define _HLIGHT_HEIGHT_I_					"<HLIGHT_HEIGHT>"
#define _HLIGHT_HEIGHT_F_					"</HLIGHT_HEIGHT>"
#define _HLIGHT_F_							"</HLIGHT>"
#define _HLIGHT_HEIGHT						"<HLIGHT_HEIGHT>"

#define _PDFNOTESVERSION_				"0.0.8"

//Point linked to PDFPage
class CPageLinkedPoint
{
public:
	CPageLinkedPoint(void);
	CPageLinkedPoint(PdfPageInfo *page, POINT p);

	PointD m_p;

	PdfPageInfo *m_pdfPage;
	int			m_numPage;

	void Set(CPageLinkedPoint *p);

	PointD GetPoint(){return m_p;};
	void SetPoint(PointD p){m_p = p;};

	PdfPageInfo * GetPdfPage(){return m_pdfPage;};
	void SetPdfPage(PdfPageInfo *page){m_pdfPage = page;};

	void SetNumPage(int n){m_numPage = n;};
	int GetNumPage(){return m_numPage;};
};

//The UnderLine Element
class CULine 
{
public:
	CULine(void);

	PointD m_p1;
	PointD m_p2;

	double	m_Zoom;
	bool	m_bIsSelected;

	COLORREF m_Color;

public:
	~CULine(void);
};

//The HighLight Element
class CHighLight
{
public:
	CHighLight(void);

	PointD	m_p1;
	PointD	m_p2;
	int		m_height;

	double	m_Zoom;
	bool	m_bIsSelected;

	RECT	GetRect();
public:
	~CHighLight(void);
};

class CLine
{
public:
	CLine(void);

	CPageLinkedPoint m_P1;
	CPageLinkedPoint m_P2;

	bool m_bIsSelected;

	double m_zoom;
public:
	~CLine(void);
};

class CNote;

class CConnector
{
public:
	CConnector(void);

	int			m_TipoIndicatore;
	int			m_PosIndicatore;
	COLORREF	m_Color;

	CNote	*m_StartNotaLinked;						//La nota da cui parte il tratto
	CNote	*m_StopNotaLinked;						//La nota di arrivo del tratto

	bool	m_IsSelected;
	int		m_1LineSelected;
	int		m_2LineSelected;

	CLine	**m_lines;
	long	m_numLines;

	CLine*	AddLine(CPageLinkedPoint p1, CPageLinkedPoint p2, double zoom);
	void	DeleteLine(int pos);
	CLine*	GetLine(int i);
	long	GetNumLines();

	void	Draw(WindowInfo *win, HDC hdc);
	void	DrawArrow(WindowInfo *win, HDC hdc);
	void	DrawArrowOnNote(WindowInfo *win, HDC hdc, CNote *note);

	bool	IsPointInAncorage(WindowInfo *win, CPageLinkedPoint pInsert);
public:
	~CConnector(void);
};

class CNote
{
public:
	CNote(void);

	CString m_strNote;
	HBITMAP m_hBmp;
	double	m_zoom;
	bool	m_bIsSelected;

	CPageLinkedPoint m_CenterPoint;
	double m_wNote;
	double m_hNote;

	LOGFONT m_lfNote;
	COLORREF m_fontColor;

	CConnector	**m_connectors;
	long		m_numConnectors;

	void		AddConnector(CConnector *st);
	void		DeleteConnector(int pos);
	CConnector*	GetConnector(int i);
	long		GetNumConnectors();

	POINT				CenterPoint();
	CPageLinkedPoint	GetPageLinkedCenterPoint();
	double	Width();
	double	Height();
	POINT	TopLeft();
	POINT	BottomRight();
	void	FindNotePoints(PointD *p1, PointD *p2, PointD *p3, PointD *p4);
	void	FindNotePoints(POINT *p1, POINT *p2, POINT *p3, POINT *p4);
	void	FindNotePoints(CPageLinkedPoint *p1, CPageLinkedPoint *p2, CPageLinkedPoint *p3, CPageLinkedPoint *p4);

	long	*m_pLoadedConnectors;
	int		m_numConnectorsLoaded;

	void AddLoadedConnector(long ConnectorPos);
public:
	~CNote(void);
};


//This Class has the elements to be drawn on a PDFPage
class CPdfNotesElements
{
public:
	CPdfNotesElements(void);

	//The UnderLines
	CULine **m_uLines;
	long m_numLines;

	//The HighLight
	CHighLight **m_hLight;
	long m_numHLight;


	CULine*	AddULine(PointD p1, PointD p2, double zoom);
	void	DeleteULine(int pos);
	CULine* GetULine(int i);
	long	GetNumULines();

	CHighLight* AddHighLight(PointD p1, PointD p2, int height, double zoom);
	void		DeleteHighLight(int pos);
	CHighLight* GetHighLight(int i);
	long		GetNumHighLight();

	bool	HasElements();
	void	DrawElements(WindowInfo *win, HDC hdc, POINT pDest, POINT pSrc);
	void	RecalcElementsPosition(double newZoom);
public:
	~CPdfNotesElements(void);
};

//This class is the general interface between PdfNotes and the struct WindoInfo 
class CPdfNotes
{
public:
	CPdfNotes(WindowInfo *win=NULL);

	bool	m_bUsePdfNotes;

	WindowInfo *m_win;	//Reference to WindowInfo

	//command of PDFNotes
	HINSTANCE m_hInst;
	bool	m_pnsInAction;
	int		m_pnsCommand;
	bool	m_bOrtho;

	CULine *m_curULine;

	//The Notes
	CNote	**m_notes;
	long	m_numNotes;
	int		m_posNoteSel;

	int m_deltaX;
	int m_deltaY;

	CNote*		AddNote(CPageLinkedPoint p, SizeD dimension , CString str, HBITMAP bmp, double zoom);
	void		DeleteNote(int pos);
	void		ModifyNote(CNote *n, CString str, SizeD dimension, HBITMAP bmp);
	CNote*		GetNote(int i);
	long		GetNumNote();

	bool		IsNoteVisible(WindowInfo *win, HDC hdc,  CNote *n, RECT *rSup);
	bool		IsNoteSelected(WindowInfo *win, int x, int y);
	bool		IsConnectorSelected(CPageLinkedPoint pIns);
	bool		IsHighLightSelected(WindowInfo *win, int x, int y);
	void		MoveNote(CNote *n, WindowInfo *win, int x, int y);

	void		RecalcNotesPosition(double newZoom, DisplaySettings *displaySettings, DisplayModel *dm);
	void		RecalcConnectorsPosition(double newZoom, DisplaySettings *displaySettings, DisplayModel *dm);

	int			m_xOrigin;

	LOGFONT		m_lfForViewNote;
	LOGFONT		m_lfNote;
	COLORREF	m_fontColor;

	COLORREF	m_ConnectorColor;
	COLORREF	m_ULineColor;

	void		InitializeNoteFont();
	void		ModifyFontNotes(int posNote, HFONT hfont, COLORREF color);

	//Connector
	CConnector	**m_connectors;
	long		m_numConnectors;
	int			m_curConnector;
	int			m_curConnectorLine;

	CConnector*	AddConnector();
	void		DeleteConnector(int pos);
	CConnector*	GetConnector(int i);
	long		GetNumConnectors();

	void		NewConnector(WindowInfo *win, CPageLinkedPoint pInsert);
	void		DeleteConnectorSelected();


	PdfPageInfo *m_pPageInfoSel;
	int			m_posHLightSel;
	int			m_posULineSel;

	//HighLight
	int		m_curHeightPt;
	CHighLight *m_curHLight;

	//WindowLess RichEdit
	CRtf2Bmp	*m_Rtf2Bmp;


	void		SelectCurHeightHighLight(HMENU hmenu);

	//Implementation
	void Load(HINSTANCE h);
	void OnPaint(HDC hdc/*, WindowInfo *win*/);

	//Mouse events
	void OnMouseMove(/*WindowInfo *win,*/ int x, int y, WPARAM flags, bool *bForceRepaint);
	void OnMouseLeftButtonDown(/*WindowInfo *win,*/ int x, int y, bool *bForceRepaint);
	void OnMouseLeftButtonUp(/*WindowInfo *win,*/ int x, int y, bool *bForceRepaint);
	void OnMouseRightButtonDown(/*WindowInfo *win,*/ int x, int y, bool *bForceRepaint);
	void OnMouseLeftButtonDblClick(/*WindowInfo *win,*/ int x, int y, bool *bForceRepaint);

	PdfPageInfo*		ConvertPointToPage (WindowInfo *win, POINT *p);
	PdfPageInfo*		ConvertPointToPageEX (WindowInfo *win, POINT *p, int *numPage = NULL);
	CPageLinkedPoint	ConvertPointToPageEX (WindowInfo *win, int x, int y);
	void VerifyDrawingArea(WindowInfo *win, int x, int y);
	void VerifyDrawingArea(DisplayModel *dm);
	bool IsULineSelected(WindowInfo *win, int x, int y);
	void DeleteULineSelected();
	void DeleteHLightSelected();

	//Geometrical functions
	PointD	CalcolaPointOrtho(PointD pPrec, PointD pCur);

	//Open and Save PNS File
	char    PNSFileName[MAX_PATH];
	void	SavePNS(char *pathFile, WindowInfo *win);
	void	OpenPNS(char *pathFile, WindowInfo *win);
	char*	WriteString(char *data, CString str, long *InsPos);
	CString ReadString(char *data, long *curPos, long FileLen);
	int		GetPosConnector(CConnector *st);
	int		GetPosNote(CNote *n);
	bool	IsSameFile(CString pathFromPNS, const char *pathLoaded);
	void	FreeResurces(WindowInfo *win);

public:
	~CPdfNotes(void);
};
